﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;


namespace Julia_UI
{
    public partial class main_window : Form
    {
        public main_window()
        {
            InitializeComponent();
            combo_resolution.SelectedItem = "500";
            combo_box_function.SelectedIndex = 0;
            combo_box_color_red.SelectedIndex = 3;
            combo_box_color_green.SelectedIndex = 3;
            combo_box_color_blue.SelectedIndex = 2;

        }

        private void canvas_Click(object sender, EventArgs e)
        {

        }

        private void canvas_redraw_ValueChanged(object sender, EventArgs e)
        {
            if (check_box_redraw.Checked)
            {

                //get values
                double a = (double)constant_real.Value;
                double b = (double)constant_imaginary.Value;
                double x = (double)real_starting.Value;
                double y = (double)imaginary_starting.Value;
                double xoff = (double)canvas_size.Value;
                int maxiter = (int)((double)maxiteration.Value);
                int dimension = int.Parse(combo_resolution.Text);
                int[] color_choice = { combo_box_color_red.SelectedIndex, combo_box_color_green.SelectedIndex, combo_box_color_blue.SelectedIndex };

                //fix text
                label_constant.Text = a.ToString("F4") + " + " + b.ToString("F4") + "i";
                label_starting_point.Text = x.ToString("F4") + " + " + y.ToString("F4") + "i";
                label_canvas_size_from_to.Text = string.Format("From  {0:+0.0000;-0.0000} {1:+0.0000;-0.0000}i  to  {2:+0.0000;-0.0000} {3:+0.0000;-0.0000}i", (x - xoff), (y - xoff), (x + xoff), (y + xoff));

                //draw
                Bitmap picture = new Bitmap(1, 1);
                if (combo_box_function.SelectedIndex == 0)
                {
                    picture = Fractal_Generator.Julia_to_Picturebox(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Julia_Color);
                }
                else if (combo_box_function.SelectedIndex == 1)
                {
                    picture = Fractal_Generator.Julia_to_Picturebox(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Mandelbrot_Color);
                }
                else if (combo_box_function.SelectedIndex == 2)
                {
                    picture = Fractal_Generator.Julia_to_Picturebox(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Exponential_Color);
                }
                else if (combo_box_function.SelectedIndex == 3)
                {
                    picture = Fractal_Generator.Julia_to_Picturebox(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Exponential_plus_linear_Color);
                }
                else if (combo_box_function.SelectedIndex == 4)
                {
                    picture = Fractal_Generator.Julia_to_Picturebox(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Sinh_z_square_Color);
                }
                else if (combo_box_function.SelectedIndex == 5)
                {
                    picture = Fractal_Generator.Julia_to_Picturebox(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Z_power_3_Color);
                }
                else if (combo_box_function.SelectedIndex == 6)
                {
                    picture = Fractal_Generator.Julia_to_Picturebox(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Z_power_4_Color);
                }
                canvas.Image = picture;

            }

        }

        private void main_window_Load(object sender, EventArgs e)
        {
            //get values
            double a = (double)constant_real.Value;
            double b = (double)constant_imaginary.Value;
            double x = (double)real_starting.Value;
            double y = (double)imaginary_starting.Value;
            double xoff = (double)canvas_size.Value;
            int maxiter = (int)((double)maxiteration.Value);
            int dimension = int.Parse(combo_resolution.Text);
            int[] color_choice = { combo_box_color_red.SelectedIndex, combo_box_color_green.SelectedIndex, combo_box_color_blue.SelectedIndex };

            //fix text
            label_constant.Text = a.ToString("F4") + " + " + b.ToString("F4") + "i";
            label_starting_point.Text = x.ToString("F4") + " + " + y.ToString("F4") + "i";
            label_canvas_size_from_to.Text = string.Format("From  {0:+0.0000;-0.0000} {1:+0.000000;-0.0000}i  to  {2:+0.0000;-0.0000} {3:+0.0000;-0.0000}i", (x - xoff), (y - xoff), (x + xoff), (y + xoff));

            //draw
            Bitmap picture = Fractal_Generator.Julia_to_Picturebox(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Julia_Color);
            canvas.Image = picture;
        }

        private void checkbox_constant_CheckedChanged(object sender, EventArgs e)
        {
            
            if (checkbox_constant.Checked)
            {
                constant_real.Increment = (decimal)0.001;
                constant_imaginary.Increment = (decimal)0.001;
            }
            else
            {
                constant_real.Increment = (decimal)0.01;
                constant_imaginary.Increment = (decimal)0.01;
            }
        }

        private void checkbox_starting_point_CheckedChanged(object sender, EventArgs e)
        {
            if (checkbox_starting_point.Checked)
            {
                real_starting.Increment = (decimal)0.001;
                imaginary_starting.Increment = (decimal)0.001;
            }
            else
            {
                real_starting.Increment = (decimal)0.01;
                imaginary_starting.Increment = (decimal)0.01;
            }
        }

        private void checkbox_canvas_size_CheckedChanged(object sender, EventArgs e)
        {
            if (checkbox_canvas_size.Checked)
            {
                canvas_size.Increment = (decimal)0.001;
            }
            else
            {
                canvas_size.Increment = (decimal)0.01;
            }
        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void button_draw_Click(object sender, EventArgs e)
        {
            if (check_box_save.Checked && !check_box_redraw.Checked)
            {

                //get values
                double a = (double)constant_real.Value;
                double b = (double)constant_imaginary.Value;
                double x = (double)real_starting.Value;
                double y = (double)imaginary_starting.Value;
                double xoff = (double)canvas_size.Value;
                int maxiter = (int)((double)maxiteration.Value);
                int dimension = int.Parse(combo_resolution.Text);
                int[] color_choice = { combo_box_color_red.SelectedIndex, combo_box_color_green.SelectedIndex, combo_box_color_blue.SelectedIndex };

                //fix text
                label_constant.Text = a.ToString("F4") + " + " + b.ToString("F4") + "i";
                label_starting_point.Text = x.ToString("F4") + " + " + y.ToString("F4") + "i";
                label_canvas_size_from_to.Text = string.Format("From  {0:+0.0000;-0.0000} {1:+0.0000;-0.0000}i  to  {2:+0.0000;-0.0000} {3:+0.0000;-0.0000}i", (x - xoff), (y - xoff), (x + xoff), (y + xoff));

                //draw
                 if (combo_box_function.SelectedIndex == 0)
                {
                    Fractal_Generator.Julia_to_File(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Julia_Color);
                }
                else if (combo_box_function.SelectedIndex == 1)
                {
                    Fractal_Generator.Julia_to_File(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Mandelbrot_Color);
                }
                else if (combo_box_function.SelectedIndex == 2)
                {
                    Fractal_Generator.Julia_to_File(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Exponential_Color);
                }
                else if (combo_box_function.SelectedIndex == 3)
                {
                    Fractal_Generator.Julia_to_File(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Exponential_plus_linear_Color);
                }
                else if (combo_box_function.SelectedIndex == 4)
                {
                    Fractal_Generator.Julia_to_File(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Sinh_z_square_Color);
                }
                else if (combo_box_function.SelectedIndex == 5)
                {
                    Fractal_Generator.Julia_to_File(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Z_power_3_Color);
                }
                else if (combo_box_function.SelectedIndex == 6)
                {
                    Fractal_Generator.Julia_to_File(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Z_power_4_Color);
                }
            }
            else
            {

                //get values
                double a = (double)constant_real.Value;
                double b = (double)constant_imaginary.Value;
                double x = (double)real_starting.Value;
                double y = (double)imaginary_starting.Value;
                double xoff = (double)canvas_size.Value;
                int maxiter = (int)((double)maxiteration.Value);
                int dimension = int.Parse(combo_resolution.Text);
                int[] color_choice = { combo_box_color_red.SelectedIndex, combo_box_color_green.SelectedIndex, combo_box_color_blue.SelectedIndex };

                //fix text
                label_constant.Text = a.ToString("F4") + " + " + b.ToString("F4") + "i";
                label_starting_point.Text = x.ToString("F4") + " + " + y.ToString("F4") + "i";
                label_canvas_size_from_to.Text = string.Format("From  {0:+0.0000;-0.0000} {1:+0.0000;-0.0000}i  to  {2:+0.0000;-0.0000} {3:+0.0000;-0.0000}i", (x - xoff), (y - xoff), (x + xoff), (y + xoff));

                //draw
                Bitmap picture = new Bitmap(1, 1);
                if (combo_box_function.SelectedIndex == 0)
                {
                    picture = Fractal_Generator.Julia_to_Picturebox(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Julia_Color);
                }
                else if (combo_box_function.SelectedIndex == 1)
                {
                    picture = Fractal_Generator.Julia_to_Picturebox(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Mandelbrot_Color);
                }
                canvas.Image = picture;


            }
        }

        private void check_box_save_CheckedChanged(object sender, EventArgs e)
        {
            if (check_box_save.Checked)
            {
                button_draw.Text = "Save";
            }
            else
            {
                button_draw.Text = "Draw";
            }
        }

        private void check_box_redraw_CheckedChanged(object sender, EventArgs e)
        {
            if (check_box_redraw.Checked)
            {

                check_box_save.Checked = false;
                check_box_save.Enabled = false;
                button_draw.Text = "Draw";


                //get values
                double a = (double)constant_real.Value;
                double b = (double)constant_imaginary.Value;
                double x = (double)real_starting.Value;
                double y = (double)imaginary_starting.Value;
                double xoff = (double)canvas_size.Value;
                int maxiter = (int)((double)maxiteration.Value);
                int dimension = int.Parse(combo_resolution.Text);
                int[] color_choice = { combo_box_color_red.SelectedIndex, combo_box_color_green.SelectedIndex, combo_box_color_blue.SelectedIndex };

                //fix text
                label_constant.Text = a.ToString("F4") + " + " + b.ToString("F4") + "i";
                label_starting_point.Text = x.ToString("F4") + " + " + y.ToString("F4") + "i";
                label_canvas_size_from_to.Text = string.Format("From  {0:+0.0000;-0.0000} {1:+0.0000;-0.0000}i  to  {2:+0.0000;-0.0000} {3:+0.0000;-0.0000}i", (x - xoff), (y - xoff), (x + xoff), (y + xoff));

                //draw
                Bitmap picture = new Bitmap(1, 1);
                if (combo_box_function.SelectedIndex == 0)
                {
                    picture = Fractal_Generator.Julia_to_Picturebox(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Julia_Color);
                }
                else if (combo_box_function.SelectedIndex == 1)
                {
                    picture = Fractal_Generator.Julia_to_Picturebox(dimension, dimension, x, -y, xoff, a, b, maxiter, color_choice, Fractal_Generator.Mandelbrot_Color);
                }
                canvas.Image = picture;
            }
            else
            {
                check_box_save.Enabled = true;
            }
        }



    }
}
