function p=simetrala(A,B)
% simetrala(A,B) vrne simetralo daljice AB
% p=simetrala(A,B);
% p=[a b c] (ax+by+c=0)
% A=[x1,y1], B=[x2,y2]

x1 = A(1);
y1 = A(2);
x2 = B(1);
y2 = B(2);

% a,b originalne daljice (y = kx+n --> y = -(a/b)x - c/b )
a = -(y2-y1);
b = x2-x1;

% simetrala bo oblike bx + (-a)y + cs = 0

% v "bx + (-a)y + cs = 0" vstavimo sredisce in dobimo cs
cs = -b*(x1 + x2)/2 + a*(y1 + y2)/2;

m = max([abs(b) abs(a) abs(cs)]); % normiramo, zaradi lepse oblike
p = [b,-a,cs]/m;
