function p=simetrala_kota(A,T,B)
% function p=simetrala_kota(A,T,B)
% simetrala_kota(A,B) vrne simetralo kota ATB
%
% vhod:
% A,B = sosednji tocki, ki dolocata kraka kota
% T = vrh kota
%
% izhod:
% p=[a b c] (ax+by+c=0)


ae = (A-T)/norm(A-T); % enotski vektor iz T v smeri A
be = (B-T)/norm(B-T); % enotski vektor iz T v smeri B

% tocki na krakih
PA = T(1,:)+ae;
PB = T(1,:)+be;

p = simetrala(PA,PB); % simetrala kota v T