function [S,r]=vcrtana_kroznica(T)
% vcrtana_kroznica vrne sredisce in radij vcrtane kroznice
% [S,r]=vcrtana_kroznica(T) vrne sredisce in radij trikotniku T vcrtanega kroga
% T je podan kot 3x2 matrika tock: [x1 y1; x2 y2; x3 y3].

% simetrala kota pri T(2,:)
p1 = simetrala_kota(T(1,:),T(2,:),T(3,:));

% simetrala kota pri T(3,:)
p2 = simetrala_kota(T(2,:),T(3,:),T(1,:));

% sredisce kroga
S = presek_premic(p1,p2);

% dolzine stranic
a = norm(T(2,:)-T(1,:));
b = norm(T(3,:)-T(2,:));
c = norm(T(3,:)-T(1,:));

s = 1/2*(a+b+c);
p = sqrt(s*(s-a)*(s-b)*(s-c)); % ploscina trikotnika (Heronova formula)
r = p/s; % radij kroga

end




