﻿using System;
using System.Collections.Generic;
using System.Text;

namespace BancniRacun
{
    public class BancniRacun
    {
        private decimal stanje;

        public BancniRacun(decimal znesek = 0)
        {
            this.stanje = 0;
            this.Polog(znesek); // pozor- že na začetku kontrola!!!
        }
        public decimal Stanje
        {
            get { return this.stanje; }
        }
        /// <summary>
        /// Polog denarja. 
        /// </summary>
        /// <param name="koliko">koliko položimo. Pri neg. vrednosti sprožimo izjemo.</param>
        public void Polog(decimal koliko)
        {
            if (koliko < 0) throw new ArgumentException("Ne moremo položiti neg. vsote");
            this.stanje += koliko;
        }
        /// <summary>
        /// Dvig denarja
        /// </summary>
        /// <param name="koliko">znesek, ki ga dvigamo</param>
        /// <returns>true - če je bil dvig možen in false,
        /// če ni bil (takrat stanje ostane nespremenjeno)</returns>
        public bool Dvig(decimal koliko)
        {
            if (koliko < 0) throw new ArgumentException("Ne moremo dvigniti neg. vsote");
            if (koliko > this.Stanje) return false;
            this.stanje -= koliko;
            return true;
        }

        public override string ToString()
        {
            return "Stanje:\t" + this.Stanje;
        }
    }
}
