﻿using System;
using System.Collections.Generic;
using System.Text;

namespace BancniRacun
{
    public class BancniRacun_V3
    {
        private decimal stanje;
        private static decimal obresti = 3.2M;
        private static int kolikoObjektov = 0;

        public BancniRacun_V3(decimal znesek = 0)
        {
            BancniRacun_V3.kolikoObjektov += 1;
            this.stanje = 0;
            this.Polog(znesek); // pozor- že na začetku kontrola!!!
        }

        public static int KolikoRacunov
        {
            get { return BancniRacun_V3.kolikoObjektov; }
        }

        public decimal Stanje
        {
            get { return this.stanje; }
        }
        /// <summary>
        /// Polog denarja. 
        /// </summary>
        /// <param name="koliko">koliko položimo. Pri neg. vrednosti sprožimo izjemo.</param>
        public void Polog(decimal koliko)
        {
            if (koliko < 0) throw new ArgumentException("Ne moremo položiti neg. vsote");
            this.stanje += koliko;
        }
        /// <summary>
        /// Dvig denarja
        /// </summary>
        /// <param name="koliko">znesek, ki ga dvigamo</param>
        /// <returns>true - če je bil dvig možen in false,
        /// če ni bil (takrat stanje ostane nespremenjeno)</returns>
        public bool Dvig(decimal koliko)
        {
            if (koliko < 0) throw new ArgumentException("Ne moremo dvigniti neg. vsote");
            if (koliko > this.Stanje) return false;
            this.stanje -= koliko;
            return true;
        }

        public static decimal Obresti
        {
            get { return BancniRacun_V3.obresti; }
            set
            {
                if (value < 0) throw new ArgumentException("Obresti niso negativne!");
                BancniRacun_V3.obresti = value;
            }
        }

        /// <summary>
        /// Razmnožimo račun
        /// </summary>
        /// <param name="koliko"></param>
        /// <param name="racun"></param>
        /// <returns>nov bančni račun s koliko-krat denarja</returns>
        public static BancniRacun_V3 operator * (int koliko, BancniRacun_V3 racun)
        {
            return new BancniRacun_V3(racun.Stanje * koliko);
        }

        public static BancniRacun_V3 operator *(BancniRacun_V3 racun, int koliko)
        {
            return koliko * racun; // pokličemo zgornjo metodo!
        }

        public override string ToString()
        {
            return "Stanje:\t" + this.Stanje;
        }


        //TO DO: pripis obresti, zapomniti si račune, kjer je bilo to že izvedeno (private bool ... brez get/set)
    }

}
