function P=kar_poli(a,b);
%KAR_POLI vrne koeficiente polinoma, podanega z rekurzijo
%P=KAR_POLI(a,b);
%a je stolpec koeficientov (dim. n)
%b je stolpec koeficientov (dim. n-1)
n=length(a);
if n==1
    P=[-1 a(1)];
else
    T=zeros(3,n+1);
    T(1,end)=1;
    T(2,[end-1:end])=[-1 a(1)];
    for i=2:n
        T(3,:)=a(i)*T(2,:)-b(i-1)^2*T(1,:)-[T(2,2:end),0];
        T([1,2],:)=T([2,3],:);
    end
end
P=T(3,:);
