%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% razpoznavanje stevk - ucenje & testiranje %%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%-------- nalozimo ucne podatke --------% 
% matrika A: stolpci predstavljajo slike stevk
A = importdata('MatrikaSlik', ';');
% vektor d: i-ta komponenta pove, katera stevka je na sliki, ki jo predstavlja i-ti stolpec matrike A
d = importdata('VektorStevk', ';');

% % narisemo eno stevko (izberemo indeks)
% k = 1;
% ima2(A(:,k))
% d(k)

%-------- zgradimo bazo vseh stevk --------%
sigma_r = 5; % velikost podprostora za vsako stevko (poiscemo pravo velikost, npr. narisemo vse sing vrednosti in ocenimo, katere so se pomembne)
B = cell(1,10); % v B bodo shranjene vse baze za stevke 0-9
for i = 1:10
    B{i} = baza(i-1,A,d,sigma_r);
end




%-------- nalozimo testne podatke --------%
A_test = importdata('MatrikaSlikZaTestiranje', ';'); % testna matrika
d_test = importdata('VektorStevkZaTestiranje', ';'); % testni vektor

% % vzamemo eno testno stevko (izberemo indeks)
% k2 = 502;
% sl_k2 = A_test(:,502);
% ima2(sl_k2)
% klasifikator(sl_k2,B,pis) % vrne, katero stevilko je prepoznal


% izracunamo procent tocnih decimalk
stevec = 0; 
for j = 1:length(d_test)
    if klasifikator(A_test(:,j),B) == d_test(j)
        stevec = stevec+1; 
    end        
end

disp(['procent tocnih dolocitev stevk: ', num2str(100*stevec/length(d_test))])




