function Bs = baza(stevka, A, d, sigma_r)
% function Bs = baza(stevka, A, d, sigma_r)
%
% Iz ucnih podatkov v matriki A = (a_{i,j})_{i=1,j=1}^{256 x N} in preko
% vektorja d=(d_j)_{j=1}^N vrne bazo Bs za stevko 'stevka', ki ima 'sigma_r'
% elementov.
% Stolpci v matriki predstavljajo 16*16 sliko. Element d_j ima vrednost med
% 0-9 in pove, katera stevka je na sliki, ki je shranjena v j-tem stolpcu.

if nargin == 3
    sigma_r = 5; % privzeto stevilo baznih vektorjev
end

N = length(d);
As = []; % notri bomo v stolpce shranili vse slike, ki pripadajo stevki "stevka"
% izluscimo samo tiste slike, ki predstavljajo stevko "stevka", zanka tece po vseh elementih ucnih primerov slik v A
for i=1:N
   if d(i)==stevka
       As = [As A(:,i)];
   end
end

% izracunamo singularni razcep U*S*V' = As
[U,~,~] = svd(As);

% za bazo vzamemo sigma_r prvih stolpcev matrike U (matrika U nam opisuje im(A), torej prostor, kjer so narisane stevke)
% tu lahko preverimo, ce smo izbrali smiseln sigma_r; npr. pogledamo, kje so se signifikantne singularne vrednosti, lahko tudi narisemo posamezne stolpce U-ja
Bs = U(:,1:sigma_r);

