function stevka = klasifikator(t,B)
% function stevka = klasifikator(t,B)
%
% Klasificiramo sliko t na podlagi baze (Bs)_s za vsako stevko s=0,1,...,9.
% Izracunamo razdalje od t do (Bs)_s za vsak s. Vrnemo stevko "stevka", za
% pripadajoci (Bs)_s, kjer je razdalja najmanjsa.
% Vektor pis ("prvi indeks stevk") nam pove, kje se zacne in konca baza za
% doloceno stevko v B.

norme_t = zeros(1,10); % shranili bomo norme (razdalje od t do vsake baze)
% izracunamo, za koliko je t dalec od danih podprostorov za stevke 0-9
for s=1:10
    norme_t(s) = norm(B{s}*(B{s}'*t)-t);   % norma ostanka (razdalja od t do podprostora za stevko (j-1))
    % namig: iscemo z po mnk, da bo "||B*z-t||" cim manjsa, upostevamo se, da iz predolocenega sistema dobimo B*z = t  --> B'*B*z = z = B'*t
end

% poiscemo najmanjso razdaljo in vrnemo ustrezno stevko
[~,ind] = min(norme_t);
stevka = ind-1;