
import java.util.Arrays;
import java.lang.Math;

public class Matrices {

	public static void main(String[] args) {
		// Experimenting with arrays
		
		double d = 1/Math.sqrt(2);
		double[][] rr = {{d,-d}, {d, d}};	
		double[][] ss = multiply(2,rr, 2, rr, 2);
		double[][] tt = multiply(2,ss, 2, ss, 2);
		double[][] uu = multiply(2,tt, 2, tt, 2);
		
		System.out.println(Arrays.deepToString(uu));

	}
	
	// multiply (l, aa, m, bb, n) performs matrix multiblication aa x bb
	// where aa is an l x m matrix and bb is an m x n matrix
	public static double[][] 
			multiply (int l, double[][] aa, int m, double[][] bb, int n) {
		double[][] cc = new double[l][n];
		for (int i=0; i<l; i++) {
			for (int k=0; k<n; k++) {
				double val = 0.0;
				for (int j=0; j<m; j++) {
					val += aa[i][j] * bb[j][k];
				}
				cc[i][k] = val;
			}
		}
		return cc;		
	}

}
