package myholders;

import java.util.LinkedList;

public abstract class LinkedListHolder<E> implements Holder<E> {
	
	// The field holder is neither private nor public
	// This makes it "package private", i.e. available to classes in the package myholders
	LinkedList<E> holder;
	
	public LinkedListHolder () {
		holder = new LinkedList<E> ();
		
	}
	
	public void put (E val) {
		holder.add(0, val);
	}
	
	abstract public E take ();
	
	public int size () {
		return holder.size ();
	}
	
	public boolean contains (E val) {
		return holder.contains (val);	
	}
	
	public void clear () {
		holder.clear();
	}


}
