import java.awt.Color;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;

public class Brownian {
	
	public static void main(String[] args) {
		
		Random random = new Random ();

		LinkedList<Double> pot = new LinkedList<Double>();
		pot.addLast(0.0);
		pot.addLast(random.nextGaussian());
		
		final int DEPTH = 12;
		
		for (int n = 0; n < DEPTH; n++) {			
			ListIterator<Double> iterator = pot.listIterator();
			Double previous = iterator.next();
			Double next;
			while (iterator.hasNext()) {
				next = iterator.next();
				iterator.remove();
				Double between = (previous + next)/2.0 + random.nextGaussian()*Math.pow(2.0,-(n+2)/2.0);
				iterator.add(between);
				iterator.add(next);
				previous = next;				
			}	
		}
		
		Okno okno = new Okno ();
		
		okno.pack();
		okno.setVisible(true);	
		
		okno.setPot(pot);
		
	}

}
