import java.awt.Color;
import java.awt.Graphics;

public class Kvadrat extends Lik {

	private double stranica;
	private double x0, y0, x1, y1, x2, y2, x3, y3; // Koordinate robov
	
	public Kvadrat(double x, double y, double theta, Color barva, double stranica) {
		super(x, y, theta, barva);
		this.stranica = stranica;
		izracunajRobe();
	}

	private void izracunajRobe () {
		double doRoba = stranica / Math.sqrt(2);
		x0 = x + doRoba * Math.cos(theta + Math.PI/4);
		y0 = y + doRoba * Math.sin(theta + Math.PI/4);
		x1 = x + doRoba * Math.cos(theta + 3*Math.PI/4);
		y1 = y + doRoba * Math.sin(theta + 3*Math.PI/4);
		x2 = x + doRoba * Math.cos(theta + 5*Math.PI/4);
		y2 = y + doRoba * Math.sin(theta + 5*Math.PI/4);
		x3 = x + doRoba * Math.cos(theta + 7*Math.PI/4);
		y3 = y + doRoba * Math.sin(theta + 7*Math.PI/4);
	}
	
	@Override
	public void premakni(double dx, double dy) {
		super.premakni(dx, dy);
		izracunajRobe();
	}
	
	@Override
	public void zavrti (double dtheta) {
		super.zavrti(dtheta);
		izracunajRobe();
	}
	
	@Override
	public boolean vsebujeTocko(double x, double y) {
		return (x1-x0) * (x-x0) + (y1-y0) * (y-y0) >= 0 &&
				(x2-x1) * (x-x1) + (y2-y1) * (y-y1) >= 0 &&
				(x3-x2) * (x-x2) + (y3-y2) * (y-y2) >= 0 &&
				(x0-x3) * (x-x3) + (y0-y3) * (y-y3) >= 0;
	}
	
	@Override
	public void narisiSe(Graphics g) {
		g.setColor(this.barva);
		int[] xPoints = {(int) Math.round(x0), (int) Math.round(x1), 
				(int) Math.round(x2), (int) Math.round(x3)};
		int[] yPoints = {(int) Math.round(y0), (int) Math.round(y1), 
				(int) Math.round(y2), (int) Math.round(y3)};
		g.fillPolygon(xPoints, yPoints, 4);
	}
	
}
