
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.LinkedList;

import javax.swing.JPanel;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;


@SuppressWarnings("serial")
public class Platno extends JPanel implements MouseListener, MouseMotionListener {

	private LinkedList<Lik> liki;

	private int prejsnjiX, prejsnjiY;
	private Lik premikajociLik;

	public Platno () {
		this.setPreferredSize(new Dimension(750,750));
		this.setBackground(Color.white);	
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
		this.liki = new LinkedList<Lik>();
	}

	public void addLik(Lik l) {
		liki.addLast(l);
	}

	public boolean removeLik(Lik l) {
		return liki.remove(l);
	}

	@Override
	protected void paintComponent(Graphics g) {
		for (Lik l : this.liki) {
			l.narisiSe(g);
		}
		this.repaint();
	}

	@Override
	public void mouseClicked(MouseEvent e) {
		System.out.println("Mouse clicked");
		int x = e.getX();
		int y = e.getY();
		Lik izbraniLik = null;
		for (Lik l: this.liki) {
			if (l.vsebujeTocko(x, y)) izbraniLik = l;
		}
		if (izbraniLik != null) this.removeLik(izbraniLik);            
	}

	@Override
	public void mousePressed(MouseEvent e) {
		System.out.println("Mouse pressed");
		int x = e.getX(); int y = e.getY();
		Lik izbraniLik = null;
		for (Lik l: this.liki) {
			if (l.vsebujeTocko(x, y)) izbraniLik = l;
		}
		if (izbraniLik != null) {
			this.removeLik (izbraniLik);
			this.addLik (izbraniLik);	 
			premikajociLik = izbraniLik;
			prejsnjiX = x; prejsnjiY = y;	 
		}      
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		System.out.println("Mouse released");
		premikajociLik = null;         
	}

	@Override
	public void mouseEntered(MouseEvent e) {
		System.out.println("Mouse entered");
	}

	@Override
	public void mouseExited(MouseEvent e) {
		System.out.println("Mouse exited");
	}

	@Override
	public void mouseDragged(MouseEvent e) {
		System.out.println("Mouse dragged");
		if (premikajociLik != null) {
			int x = e.getX(); int y = e.getY();
			premikajociLik.premakni(x-prejsnjiX,y-prejsnjiY);
			prejsnjiX = x; prejsnjiY = y;
		}
	}

	@Override
	public void mouseMoved(MouseEvent e) {
		System.out.println("Mouse moved");
	}

}
