import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import java.util.List;

import javax.swing.JPanel;

@SuppressWarnings("serial")
public class Platno extends JPanel implements MouseListener, MouseMotionListener {
	
	private List<Poteza> poteze;
	private Poteza aktivnaPoteza;
	
	public Platno(int sirina, int visina) {
		this.setBackground(Color.white);
		this.setPreferredSize(new Dimension(sirina, visina));
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
		this.poteze = new LinkedList<Poteza>();

	}

	@Override
	protected void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D)g;
		for (Poteza p : poteze) {
			p.narisi(g2);
		}
		if (aktivnaPoteza != null) {
			aktivnaPoteza.narisi(g2);
		}
	}

	@Override
	public void mouseClicked(MouseEvent e) { }

	@Override
	public void mousePressed(MouseEvent e) {
		aktivnaPoteza = new Poteza(Color.black, 5, e.getX(), e.getY());
		this.repaint();
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		aktivnaPoteza.dodajTocko(e.getX(), e.getY());
		poteze.add(aktivnaPoteza);
		aktivnaPoteza = null;
		this.repaint();
	}

	@Override
	public void mouseEntered(MouseEvent e) {
	}

	@Override
	public void mouseExited(MouseEvent e) {
	}

	@Override
	public void mouseDragged(MouseEvent e) {
		aktivnaPoteza.dodajTocko(e.getX(), e.getY());
		this.repaint();
	}

	@Override
	public void mouseMoved(MouseEvent e) {	
	}	
}
