import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;

import javax.swing.JPanel;

@SuppressWarnings("serial")
public class Platno extends JPanel implements MouseListener, MouseMotionListener {
	
	private LinkedList<Poteza> poteze;
	private Poteza aktivnaPoteza;
	
	private Color aktivnaBarva;
	private int aktivnaSirina;
	
	
	public Platno(int sirina, int visina) {
		this.setPreferredSize(new Dimension(sirina,visina));
		this.setBackground(Color.WHITE);
		aktivnaBarva = Color.BLACK;
		aktivnaSirina = 11;
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
		this.poteze = new LinkedList<Poteza> ();

	}
	
	public LinkedList<Poteza> getPoteze () {
		return poteze;
	}
	
	public void setPoteze (LinkedList<Poteza> poteze) {
		this.poteze = poteze;
		repaint();
	}
	
	public void setBarva (Color barva) {
		this.aktivnaBarva = barva;
	}
	
	public Color getBarva () {
		return aktivnaBarva;
	}
		
	public void setSirina (int sirina) {
		this.aktivnaSirina = sirina;
	}
	
	public void zbrisiVse () {
		poteze = new LinkedList<Poteza>();
		repaint();
	}
	
	public void zbrisi () {
		if (!poteze.isEmpty()) {
			poteze.removeLast ();
			repaint();
		}
	}


	@Override
	protected void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D)g;
		for (Poteza p : poteze) {
			p.narisi(g2);
		}
		if (aktivnaPoteza != null) {
			aktivnaPoteza.narisi(g2);
		}
	}

	@Override
	public void mouseClicked(MouseEvent e) {
	}

	@Override
	public void mousePressed(MouseEvent e) {
		aktivnaPoteza = new Poteza(aktivnaBarva, aktivnaSirina, e.getX(), e.getY());
		this.repaint();
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		aktivnaPoteza.dodajTocko(e.getX(), e.getY());
		poteze.addLast(aktivnaPoteza);
		aktivnaPoteza = null;
		this.repaint();
	}

	@Override
	public void mouseEntered(MouseEvent e) {
	}

	@Override
	public void mouseExited(MouseEvent e) {
	}

	@Override
	public void mouseDragged(MouseEvent e) {
		aktivnaPoteza.dodajTocko(e.getX(), e.getY());
		this.repaint();
	}

	@Override
	public void mouseMoved(MouseEvent e) {
	}
	
	
}
