import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;

import javax.swing.JFrame;
import javax.swing.JPanel;

public class Sladoled {

	public static void main(String[] args) {
		Okno okno = new Okno();
		okno.pack();
		okno.setVisible(true);
	}
}

//---------------------------------------------------

@SuppressWarnings("serial")
class Okno extends JFrame {
	
	private Platno platno;
	
	public Okno() {
		super("Sladoled");
		platno = new Platno();
		add(platno);
	}
}

//---------------------------------------------------

@SuppressWarnings("serial")
class Platno extends JPanel {

	public Platno() {
		super();
		setPreferredSize(new Dimension(600, 400));
	}
	
	@Override
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		
		int sirina = getWidth();
		int visina = getHeight();
		
		int x1 = round(0.05 * sirina);
		int x2 = round(0.275 * sirina);
		int x3 = round(0.5 * sirina);
		int y0 = round(0.3 * visina);
		int sir = round(0.175 * sirina);
		int vis = round(0.4 * visina);
		
		Graphics2D g2 = (Graphics2D)g;
		g2.setStroke(new BasicStroke(5));
		
		banjica(g, x1, y0, sir, vis, Okus.COKOLADA);
		banjica(g, x2, y0, sir, vis, Okus.JAGODA);
		banjica(g, x3, y0, sir, vis, Okus.VANILIJA);
		
		Polygon kornet = new Polygon();
		kornet.addPoint(round(0.75 * sirina), round(0.3 * visina));
		kornet.addPoint(round(0.95 * sirina), round(0.3 * visina));
		kornet.addPoint(round(0.85 * sirina), round(0.7 * visina));
		g.setColor(new Color(169, 113, 55, 192));
		g.fillPolygon(kornet);
		
		int x = round(0.85 * sirina);
		int y = round(0.3 * visina);
		int r = round(0.1 * sirina);
		g.fillArc(x - r, y - r, 2 * r, 2 * r, 0, 180);
	}

	private static void banjica(Graphics g, int x, int y, int sir, int vis, Color okus) {
		g.drawRoundRect(x, y, sir, vis, 16, 16);
	}
	
	private static int round(double x) {
		return (int)(x + 0.5);
	}
}

//---------------------------------------------------

class Okus {
	public static final Color COKOLADA = new Color(110, 78, 80);
	public static final Color JAGODA = new Color(206, 145, 165);
	public static final Color VANILIJA = new Color(220, 215, 205);
}