// Import the java.util.Scanner class so we can read from the input
import java.util.Scanner;

public class Hanoi {
	
	public static void main(String[] args) {
		// Imperative Hanoi with an array recording disk positions
		// Read the number of disks from the input stream
		Scanner sc = new Scanner(System.in);
		final int N = sc.nextInt();
		sc.close();
		// Create an array with N cells, 
		// positions[i-1] will be the position of disk i
		int [] position = new int[N];
		// Initialise the array so all disks are at position 1
		for (int i=0; i<N; i++) position[i]=1;
		System.out.println("Start");
		printPosition (N,position);
		// Step through 2^{n-1} moves
		int steps = (int) Math.pow(2,N);
		for (int i=1; i < steps; i++) {
			int disk = findDisk(i);
			int direction = (disk+N)%2;
			// Get the current position of disk and change to next position
			int now = position[disk-1];
			int next = (direction == 0) ? (now%3)+1 : (now+1)%3+1 ;
			position[disk-1] = next;
			// Print move
			System.out.print("Move disk " + disk);
			if (direction == 0) {System.out.print(" clockwise");}
			else {System.out.print(" anticlockwise");};
			System.out.println(" from " + now + " to " + next + ".");
			printPosition (N,position);
		}
		System.out.println("Finish");
	}
	
	public static int findDisk (int step) {
		if (step%2 ==1) {return 1;}
		else {return 1 + findDisk(step/2);}
	}
	
	public static void printPosition (int n, int[] p) {
		System.out.print(" Position: ");
		for (int j=0; j<n; j++) {
			System.out.print("disk " + (j+1) + " on tower " + p[j]);
			if (j<n-1) {System.out.print("; ");}
		}
		System.out.println(".");
	}

}
