import java.io.*;

public class FileWords {

	public static void main(String[] args) {

		// Reads a text file and outputs to a text file
		// all consecutive sequences of letters as words 
		// separated by single spaces

		try (FileReader in = new FileReader("/Users/simpson/in.txt"); 
				FileWriter out = new FileWriter("/Users/simpson/out.txt")) {
			int c;
			boolean space = false;
			while ((c = in.read()) != -1) {
				if (Character.isLetter(c)) {
					// if the character c is a letter write it to output file
					// and flag that a space is needed after
					out.write(c); space = true;
				}
				else if (space) {
					// if the character c is not a letter then write
					// a space only if the space flag says that one is needed.
					out.write((int) ' '); 
					// After writing a space we do not need another
					space = false;
				}
			}
		} catch (IOException exn) {
			exn.printStackTrace();
		} 		
	}

}
