
import java.util.Random;
import java.util.Arrays;

public class QuickSort {
	
	//Randomised quicksort algorithm
	
	private static Random r = new Random(); 
	
	private static float[] array;

	public static void main(String[] args) {
		
		final int SIZE =  10000;
		//Create a randomly populated array of floats		
		array = new float[SIZE];	
		for (int i = 0; i<SIZE; i++) array[i] = r.nextFloat();		
		
		System.out.println("Before sorting:");
		System.out.println(Arrays.toString(array));
		
		//Randomised quicksort the array
		
		rqs(0,SIZE-1);
		
		System.out.println("After sorting:");
		System.out.println(Arrays.toString(array));

	}
	
	// rqs(i,j) where i <= j+1
	// randomised quicksort on array[i,...,j] 
	// (if j=i-1 then the array being sorted is empty)
	private static void rqs (int i, int j) {
		if (i < j) {// only sort if array has 2 or more elements
			
			//Choose a random pivot value
			float pval = array[i + r.nextInt(j-i+1)];
			
			int k = partition (i, pval, j);
			rqs (i, k-1);
			rqs (k+1, j);
		}
	}
	
	// partition(i,pval,j) where i <= k <= j
	// uses the pivot value pval to partition array[i,...,j].
	// Array entries are rearranged so that entries smaller than pval lie to 
	// its left and entries larger than pval lie to its right. 
	// The method returns the new index of pval in the rearranged array.	
	private static int partition (int i, float pval, int j) {
		while (i < j) {
			if (array[i] < pval) {i++;} // smaller elements stay on left 
			else if (array[j] > pval) {j--;} // larger elements stay on right
			else if (array[i] == pval && array[j] == pval) {j--;}
			else { // array[i] and array[j] out of place so swap
				float temp = array[j];
				array[j] = array[i];
				array[i] = temp;
			}
			
		}
		
		return i;
	}

}
