
import myholders.*;   // imports the myholders package we have defined

public class HolderTester {

	public static void main(String[] args) {
	
		// Simulation of the pill jar puzzle

		final int NUM_PILLS = 20;
		
		final int NUM_TRIALS = 1000000;

		MyFirstUrn<String> jar = new MyFirstUrn<String>();

		int total = 0;

		for (int trial = 0; trial < NUM_TRIALS; trial++) {
			
			jar.clear();
			for (int i = 0; i < NUM_PILLS; i++) jar.put("WHOLE");

			while (jar.contains ("WHOLE")) { 
				String pill = jar.take(); 
				if (pill.equals("WHOLE")) jar.put("half"); 
			}
			
			int numSmalls = jar.size();

			total += numSmalls;
			System.out.print ("Trial " + (trial+1) + ": ");
			System.out.println ("number of half pills = " + numSmalls);
		}
		
		double average = (double)total/NUM_TRIALS;
		System.out.println ("Expected number of half pills ~ " + average);
		
		double hn = 0.0;
		for (int n = 1; n <= NUM_PILLS; n++) hn += 1.0/n;
		System.out.println ("Harmonic number " + NUM_PILLS + " = " + hn);

	}

}
