package myholders;

import java.util.LinkedList;
import java.util.Random;

public class MyFirstUrn<E> {
	
	// implements an "urn" holder
	// where the removed element is randomly selected
	
	// random number generator associated with class
	private static final Random RANDOMS = new Random();
	
    private LinkedList<E> holder;
	
	public MyFirstUrn () {
		holder = new LinkedList<E> ();	
	}
	
	public void put (E val) {
		holder.add(0, val);
	}
	
	public E take () {
		int size = holder.size();
		int index = RANDOMS.nextInt(size);
		return holder.remove(index);	
	}		
	
	public int size () {
		return holder.size ();
	}
	
	public boolean contains (E val) {
		return holder.contains (val);	
	}
	
	public void clear () {
		holder.clear();
	}


}
