import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.LinkedList;

import javax.swing.JPanel;

@SuppressWarnings("serial")
public class Platno extends JPanel {

	private int numPoints;
	private int[] potX, potY;
	
	public Platno () {
		this.setPreferredSize(new Dimension(700,700));
		this.setBackground(Color.white);
		numPoints = 0;
		potX = new int[0];
		potY = new int[0];
	}

	public void setPot(LinkedList<Double> pot) {
		numPoints = pot.size();
		potX = new int[numPoints];
		potY = new int[numPoints];
		int xZero = 50; int yZero = 350;
		int i = 0;
		for (Double v : pot) {
			potX[i] = xZero + (int) Math.round(i * 600.0/(numPoints-1));
			potY[i] = yZero + (int) Math.round(v * 100);
			i++;
		}

	}
	

	@Override
	protected void paintComponent(Graphics g) {
		g.setColor(Color.BLACK);
		g.drawPolyline(potX, potY, numPoints);
		this.repaint();
	}
	

}
