import java.awt.Color;
import java.awt.Graphics;

public class NKotnik extends Lik {
	
	private int n;
	private double stranica;
	private double[] robiX, robiY; // Koordinate robov
	
	public NKotnik(int n, double x, double y, double theta, Color barva, double stranica) {
		super(x, y, theta, barva);
		this.stranica = stranica;
		this.n = n;
		robiX = new double[n]; robiY = new double[n];
		izracunajRobe();
	}

	private void izracunajRobe () {
		double doRoba = stranica / (2 * Math.sin(Math.PI/n));
		for (int i = 0; i < n ; i++) {
			robiX[i] = x + doRoba * Math.cos(theta + i * 2 * Math.PI / n);
			robiY[i] = y + doRoba * Math.sin(theta + i * 2 * Math.PI / n);
		}
	}
	
	@Override
	public void premakni(double dx, double dy) {
		super.premakni(dx, dy);
		izracunajRobe();
	}
	
	@Override
	public void zavrti (double dtheta) {
		super.zavrti(dtheta);
		izracunajRobe();
	}

	@Override
	public boolean vsebujeTocko(double x, double y) {
		for (int i = 0; i < n ; i++) {
			double x0 = robiX[i] ; double x1 = robiX[(i+1)%n];
			double y0 = robiY[i] ; double y1 = robiY[(i+1)%n];
			if ((y0-y1) * (x-x0) + (x1-x0) * (y-y0) < 0) return false;
		}
		return true;
	}

	@Override
	public void narisiSe(Graphics g) {
		g.setColor(this.barva);
		int[] xPoints = new int[n];
		int[] yPoints = new int[n];
		for (int i = 0; i < n ; i++) {
			xPoints[i] = (int) Math.round(robiX[i]);
			yPoints[i] = (int) Math.round(robiY[i]);
		}
		g.fillPolygon(xPoints, yPoints, n);
	}

}
