import java.awt.Color;
import java.awt.Graphics;

public class Trikotnik extends Lik {
	
	private double stranica;
	private double x0, y0, x1, y1, x2, y2; // Koordinate robov
	
	public Trikotnik(double x, double y, double theta, Color barva, double stranica) {
		super(x, y, theta, barva);
		this.stranica = stranica;
		izracunajRobe();
	}

	private void izracunajRobe () {
		double doRoba = stranica / Math.sqrt(3);
		x0 = x + doRoba * Math.cos(theta - Math.PI/6);
		y0 = y + doRoba * Math.sin(theta - Math.PI/6);
		x1 = x + doRoba * Math.cos(theta + Math.PI/2);
		y1 = y + doRoba * Math.sin(theta + Math.PI/2);
		x2 = x + doRoba * Math.cos(theta + 7*Math.PI/6);
		y2 = y + doRoba * Math.sin(theta + 7*Math.PI/6);
	}
	
	@Override
	public void premakni(double dx, double dy) {
		super.premakni(dx, dy);
		izracunajRobe();
	}
	
	@Override
	public void zavrti (double dtheta) {
		super.zavrti(dtheta);
		izracunajRobe();
	}

	@Override
	public boolean vsebujeTocko(double x, double y) {
		return (y0-y1) * (x-x0) + (x1-x0) * (y-y0) >= 0 &&
				(y1-y2) * (x-x1) + (x2-x1) * (y-y1) >= 0 &&
				(y2-y0) * (x-x2) + (x0-x2) * (y-y2) >= 0;
	}

	@Override
	public void narisiSe(Graphics g) {
		g.setColor(this.barva);
		int[] xPoints = {(int) Math.round(x0), (int) Math.round(x1), 
				(int) Math.round(x2)};
		int[] yPoints = {(int) Math.round(y0), (int) Math.round(y1), 
				(int) Math.round(y2)};
		g.fillPolygon(xPoints, yPoints, 3);
	}


}
