import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.FlowLayout;

import java.util.LinkedList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.IOException;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.*;

@SuppressWarnings("serial")
public class Okno extends JFrame implements ActionListener, ChangeListener {

	private Platno platno;

	private JButton zbrisiVse;
	private JButton zbrisi;
	private JSlider sirinaSlider;
	private JButton izberiBarvo;
	private JLabel aktivnaBarvaLabel;
	private JButton shrani;
	private JButton nalozi;

	private final JFileChooser FC = new JFileChooser ();

	public Okno(int width, int height) {
		setTitle("Slikar");

		// Glavna plošča
		JPanel glavnaPlosca = new JPanel();
		glavnaPlosca.setLayout(new BoxLayout(glavnaPlosca, BoxLayout.Y_AXIS));
		this.add(glavnaPlosca);

		// Platno, na katerega rišemo
		platno = new Platno(width, height);

		glavnaPlosca.add(platno);

		// JPanel za orodja
		JPanel orodjarna = new JPanel();

		// Orodja postavimo v orodjarno

		// Gumb, ki zbriše vse
		zbrisiVse = new JButton("Zbriši vse");
		orodjarna.add(zbrisiVse);
		zbrisiVse.addActionListener(this);
		
		// Gumb, ki zbriše zadnje potezo
		zbrisi = new JButton("Zbriši");
		orodjarna.add(zbrisi);
		zbrisi.addActionListener(this);

		// Izbor širine
		sirinaSlider = new JSlider(JSlider.HORIZONTAL, 1, 21, 11);
		sirinaSlider.setMajorTickSpacing(5);
		sirinaSlider.setPaintTicks(true);
		orodjarna.add(sirinaSlider);
		sirinaSlider.addChangeListener(this);

		// Izbor barv 
		Color aktivnaBarva = Color.BLACK;
		aktivnaBarvaLabel = new JLabel("      ");
		aktivnaBarvaLabel.setOpaque(true);
		aktivnaBarvaLabel.setBackground(aktivnaBarva);
		platno.setBarva(aktivnaBarva);
		izberiBarvo = new JButton("Izberi barvo");
		izberiBarvo.addActionListener(this);
		orodjarna.add(aktivnaBarvaLabel);
		orodjarna.add(izberiBarvo);

		glavnaPlosca.add(orodjarna);


		// JPanel za datoteke
		JPanel datoteke = new JPanel();
		datoteke.setLayout(new FlowLayout(FlowLayout.TRAILING));

		// Shrani datoteko
		shrani = new JButton("Shrani");
		datoteke.add(shrani);
		shrani.addActionListener(this);

		// Naloži datoteko
		nalozi = new JButton("Naloži");
		datoteke.add(nalozi);
		nalozi.addActionListener(this);

		glavnaPlosca.add(datoteke);

	}

	@Override
	//@SuppressWarnings("unchecked")
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == zbrisiVse) {
			platno.zbrisiVse();
		} else if (e.getSource() == zbrisi) {
			platno.zbrisi();
		} else if (e.getSource() == izberiBarvo) {
			Color novaBarva = JColorChooser.showDialog(this, "Izberite barvo", platno.getBarva());
			if (novaBarva != null) {
				platno.setBarva(novaBarva);
				aktivnaBarvaLabel.setBackground(novaBarva);
			}
		} else if (e.getSource() == shrani) {
			int returnVal = FC.showSaveDialog(this);	
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				File file = FC.getSelectedFile();
				try (FileOutputStream fileOut = new FileOutputStream(file);
						ObjectOutputStream objectOut = new ObjectOutputStream (fileOut)) {
					objectOut.writeObject(platno.getPoteze());
				} catch (IOException exn) {
					exn.printStackTrace();
				}
			}
		} else if (e.getSource() == nalozi) {
			int returnVal = FC.showOpenDialog(this);	
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				File file = FC.getSelectedFile();
				try (FileInputStream fileIn = new FileInputStream(file); 
						ObjectInputStream objectIn = new ObjectInputStream (fileIn) ) {
					LinkedList<Poteza> poteze = (LinkedList<Poteza>) objectIn.readObject();
					platno.setPoteze(poteze);
				} catch (Exception exn) {
					exn.printStackTrace();
				}
			}
		}

	}

	@Override
	public void stateChanged(ChangeEvent e) {
		platno.setSirina(sirinaSlider.getValue());
	}

}

	