import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

// ---------------------------------------------------

public class Semafor {

	public static void main(String[] args) {
		Okno okno = new Okno();
		okno.pack();
		okno.setVisible(true);
	}
}

//---------------------------------------------------

@SuppressWarnings("serial")
class Okno extends JFrame implements ActionListener {
	
	private Platno platno;
	private JButton gumbRdeca, gumbRumena, gumbZelena;
	
	public Okno() {
		super();
		setTitle("Semafor");
		setLayout(new BorderLayout());
		
		platno = new Platno();
		add(platno, BorderLayout.CENTER);
		
		JPanel gumbi = new JPanel();
		add(gumbi, BorderLayout.NORTH);
		
		gumbRdeca = dodajGumb(gumbi, "Rdea");
		gumbRumena = dodajGumb(gumbi, "Rumena");
		gumbZelena = dodajGumb(gumbi, "Zelena");
	}

	private JButton dodajGumb(JPanel panel, String napis) {
		JButton gumb = new JButton(napis);
		gumb.addActionListener(this);
		panel.add(gumb);
		return gumb;
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		Object source = e.getSource();
		if (source == gumbRdeca) platno.prizgiLuc(Luc.RDECA);
		else if (source == gumbRumena) platno.prizgiLuc(Luc.RUMENA);
		else if (source == gumbZelena) platno.prizgiLuc(Luc.ZELENA);
	}
}

//---------------------------------------------------

@SuppressWarnings("serial")
class Platno extends JPanel {

	private Luc luc;
	
	public Platno() {
		super();
		setPreferredSize(new Dimension(400, 800));
		luc = null;
	}
	
	public void prizgiLuc(Luc luc) {
		this.luc = (luc == this.luc) ? null : luc;
		repaint();
	}
	
	@Override
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		int x = getWidth() / 2;
		int y = getHeight() / 2;
		int r = Math.min(x / 3, y / 5);
		
		Graphics2D g2 = (Graphics2D)g;
		g2.setStroke(new BasicStroke(3));
	
		g.setColor(Color.DARK_GRAY);
		g.fillRoundRect(x - 4 * r / 3, y - 4 * r, 8 * r / 3, 8 * r, 16, 16);
		g.setColor(Color.BLACK);
		g.drawRoundRect(x - 4 * r / 3, y - 4 * r, 8 * r / 3, 8 * r, 16, 16);
		
		g.setColor(Color.LIGHT_GRAY);
		g.fillOval(x - r, y - 11 * r / 3, 2 * r, 2 * r);
		g.setColor(Color.BLACK);
		g.drawOval(x - r, y - 11 * r / 3, 2 * r, 2 * r);
		
		g.setColor(Color.LIGHT_GRAY);
		g.fillOval(x - r, y - r, 2 * r, 2 * r);
		g.setColor(Color.BLACK);
		g.drawOval(x - r, y - r, 2 * r, 2 * r);
		
		g.setColor(Color.LIGHT_GRAY);
		g.fillOval(x - r, y + 5 * r / 3, 2 * r, 2 * r);
		g.setColor(Color.BLACK);
		g.drawOval(x - r, y + 5 * r / 3, 2 * r, 2 * r);
	}
}

//---------------------------------------------------

enum Luc {
	RDECA,
	RUMENA,
	ZELENA
}