#!/usr/bin/python
#-*- coding: utf-8 -*-

from bottle import *

# Zakomentiraj, če ne želiš sporočil o napakah
debug(True)

######################################################################
# Funkcije za izgradnjo strani

# Statične datoteke damo v mapo 'static' in do njih pridemo na naslovu '/static/...'
# Uporabno za slike in CSS, poskusi http://localhost:8080/static/slika.jpg
@route('/static/<filename:path>')
def static(filename):
    return static_file(filename, root='static')


######################################################################
# Glavna stran

@route('/')
def index():
    """Začetna stran: ponudi vse, kar lahko delamo."""
    # Tu bi morali dobiti podatke iz baze
    postaje = [(600012, 'Bavarski dvor'),
               (601011, 'Pošta'),
               (802021, 'Kino Šiška')]
    linije = [('1', '1 MESTNI LOG - VIŽMARJE'),
              ('6', '6 DOLGI MOST - ČRNUČE'),
              ('8', '8 GAMELJNE - BRNČIČEVA')]
    return template('index',
                    postaje=postaje,
                    linije=linije)


######################################################################
# Strani za delo s postajami

@route('/postaja/')
def postaja_spisek():
    """Glavna stran za urejanje postaj."""
    # Tu bi morali dobiti postaje iz baze
    postaje = [(600012, 'Bavarski dvor'),
               (601011, 'Pošta'),
               (802021, 'Kino Šiška')]
    return template('postaja_spisek', postaje=postaje)

@route('/postaja/prihodi/<postajaid>/')
def postaja_prihodi(postajaid):
    """Prikaži prihode na dano postajo."""    
    # 1. SELECT, s katerim dobimo podatke o postaji z id-jem postajaid
    # 2. Če SELECT crkne, javimo ustrezno napako (404 Page not found)
    # 3. Poberemo prihode za postajo, verjetno take oblike:
    #    Dan | Ura  | Linija                  | Avtobus
    #    ----------------------------------------------------
    #     d  | 6:00 | 1 MESTNI LOG - VIŽMARJE | 223
    #     s  | 8:00 | 6 DOLGI MOST - ČRNUČE   | 224
    #     ...
    # 4. Seznam iz točke 3. je treba predelati v tabelo:
    #    - vrstice so linije
    #    - stolpci so zaporedni prihodi (npr. prvi trije za linijo)
    #    Zapeljemo se čez seznam iz točke 3. in ustrezno napolnimo tabelo.
    # Tu bi morali dobiti podatke o avtobusu iz baze
    postaja = '{0}'.format(postajaid)
    okenca = {}
    # Te zanke kasneje ne bo več, ker bomo okenca napolnili z zanko iz točke 4.
    prihodi = []
    for i, linija in enumerate(['1 MESTNI LOG - VIŽMARJE',
                                '6 DOLGI MOST - ČRNUČE',
                                '8 GAMELJNE - BRNČIČEVA']):
        prihodi.append([linija, '8:%02d'%(3*i), '8:%02d'%(3*i+8), '8:%02d'%(3*i+15)])
    return template('prihodi',
                    prihodi_naslov="Prihodi na postajo {0}".format(postaja),
                    prihodi=prihodi,
                    maxprihodi=3)

@route('/postaja/dodaj/', method=['GET','POST'])
def postaja_dodaj():
    """Dodaj novo postajo."""
    id = request.forms.get('id')
    ime = request.forms.get('ime')
    smer = request.forms.get('smer')
    if id or ime or smer:
        # Ce manjka kak podatek, se pritozimo
        if not id or not ime or not smer:
            # Manjka podatek, napaka pri procesiranju,
            # pošljemo sporočilo o napaki in PRAZNO formo (to je narobe).
            return template('postaja_dodaj',
                            id=id,
                            ime=ime,
                            smer=smer,
                            sporocilo='NAPAKA: Izpolnite vsa polja')
        else:
            # Vsi podatki ok, bi naredili INSERT na tem mestu
            return template('postaja_dodaj',
                            id=id,
                            ime=ime,
                            smer=smer,
                            sporocilo='Postaja "{0}" v smeri {1} (ID {2}) je bila uspešno dodana'.format(ime,smer,id))
    else:
        return template('postaja_dodaj',
                        id='',
                        ime='',
                        smer='S',
                        sporocilo=None)

@route('/postaja/zbrisi/<postajaid>/', method=['POST','GET'])
def postaja_zbrisi(postajaid):
    """Zbriši postajo z danim id."""
    postaja = 'Tu bi moralo biti ime postaje z id-jem {0}'.format(postajaid)
    if request.forms.get('ziher'):
        # Tu bi naredili DELETE
        redirect('/postaja/')
    else:
        return template('postaja_zbrisi', postaja=postaja, postajaid=postajaid)

@route('/postaja/uredi/<postajaid>/', method=['GET','POST'])
def postaja_uredi(postajaid):
    """Zbriši postajo z danim id."""
    ime = request.forms.get('ime')
    smer = request.forms.get('smer')
    if ime or smer:
        # Tu bi naredili UPDATE v bazo.
        redirect('/postaja/')
    else:
        # Tu bi podatke o postajaid nalozili iz baze.
        ime = 'Bavarski dvor'
        smer = 'J'
        return template('postaja_uredi',
                        sporocilo=None,
                        postajaid=postajaid,
                        ime=ime,
                        smer=smer)

######################################################################
# Strani za delo s prihodi

@route('/linija/prihodi/<linijaid>/')
def linija_prihodi(linijaid):
    """Prikaži prihode za dano linijo."""
    # Ime linije bi morali dobiti iz baze
    linija = '{0}'.format(linijaid)
    okenca = {}
    urejanje = (request.GET.get('uredi') == '1')
    # Tu bi morali dobiti prihode iz baze
    prihodi = []
    for i, postaja in enumerate(['Bavarski dvor', 'Pošta', 'Kino Šiška']):
        prihodi.append([postaja, '8:%02d'%(3*i), '8:%02d'%(3*i+8), '8:%02d'%(3*i+15), '8:%02d'%(3*i+23), '8:%02d'%(3*i+30)])
    return template('prihodi',
                    prihodi_naslov='Prihodi za linijo {0}'.format(linija),
                    prihodi=prihodi,
                    maxprihodi=5)


######################################################################
# Strani za delo z linijami

@route('/linija/')
def linija_uredi():
    """Glavna stran za urejanje linij."""
    linije = [('1', '1 MESTNI LOG - VIŽMARJE'),
              ('6', '6 DOLGI MOST - ČRNUČE'),
              ('8', '8 GAMELJNE - BRNČIČEVA')]
    return template('linija_uredi', linije=linije)


######################################################################
# Stran z opozorili

@route('/opozorila/')
def opozorila():
    """Prikaže opozorila o prekršenih omejitvah."""
    opozorila = [
        'Avtobus 224 ima delavniška odhoda ob 7:38 na liniji 6 DOLGI MOST - ČRNUČE in ob 8:15 na liniji 6 ČRNUČE - DOLGI MOST preblizu skupaj!',
        'Avtobus 103 v nedeljo z odhodom ob 21:50 na liniji 19 I IG - TOMAČEVO pripelje na postajo TOMAČEVO ob 22:24 in ob 22:25 odpelje s postaje CENTER STOŽICE na liniji 13 CENTER STOŽICE - SOSTRO!',
        'Šofer Matija Zadravec ima delavnik dolg 11:04, kar presega dovoljeno mejo 10 ur!'
        ]
    return template('opozorila', opozorila=opozorila)

######################################################################
# Glavni program

# tu bi se priklopili na bazo

# Poženemo strežnik na portu 8080, glej http://localhost:8080/
# Iz bottle dokumentacije o parametru reloader=True: Every time you edit a module file, 
# the reloader restarts the server process and loads the newest version of your code. 
run(host='localhost', port=8080, reloader=True)

