#######################################################################@@#
# Permutacije 
#
# Permutacije reda $n$ so bijektivne preslikave na množici
# $\{0, \ldots, n - 1\}$, ki jih podamo s seznamom slik.
# 
# Npr. [2, 0, 1] predstavlja permutacijo, ki slika $0 \mapsto 2$,
# $1 \mapsto 0$ in $2 \mapsto 1$; seznam [3, 0, 2, 4, 1] pa predstavlja
# permutacijo, ki slika $0 \mapsto 3$, $1 \mapsto 0$, $2 \mapsto 2$,
# $3 \mapsto 4$ in $4 \mapsto 1$.
# 
# Razredu Permutacija bomo dodali konstruktor in še dve metodi. Seveda
# lahko definirate še kakšne druge metode, ki olajšajo delo, na primer
# metodo __repr__(self).
# 
# _Opomba:_ Obstoječemu razredu lahko dodate novo metodo takole (razred
# FooBar že obstaja):
# 
# class FooBar(FooBar):
# 
#     def nova_metoda(self, baz):
#         pass
#######################################################################@@#

class Permutacija:
    
    pass

##################################################################@000512#
# 1) Sestavite konstruktor __init__(self, s), ki ustvari permutacijo iz
# podanega seznama slik. Konstruktor naj v atribut s shrani kopijo
# seznama, ki je podan kot argument. Zgled:
# 
# >>> l = [3, 0, 2, 4, 1]
# >>> p = Permutacija(l)
# >>> l.append(5)
# >>> p.s
# [3, 0, 2, 4, 1]
# 
# _Pozor:_ Če se po klicu konstruktorja seznam, ki je bil podan kot
# argument, spremeni, se s tem objekt ne sme spremeniti.
##################################################################000512@#


##################################################################@000513#
# 2) Sestavite metodo __call__(self, m), ki vrne sliko števila $m$ (če je
# $m$ prevelik ali premajhen, naj vrže izjemo). Zgled:
# 
# >>> p = Permutacija([3, 0, 2, 4, 1])
# >>> p(3)
# 4
##################################################################000513@#


##################################################################@000514#
# 3) Sestavite metodo inverz(self), ki vrne inverzno permutacijo. Zgled:
# 
# >>> p = Permutacija([3, 0, 2, 4, 1])
# >>> p_inv = p.inverz()
# >>> p_inv.s
# [1, 4, 2, 0, 3]
##################################################################000514@#


#######################################################################@@#
