#######################################################################@@#
# Iskalno drevo 
#
# Iskalno drevo je podano z razredom IskalnoDrevo. Konstruktor je že
# implementiran. Kot argument dobi konstruktor seznam števil, ki jih enega
# za drugim vstavi v iskalno drevo, tako da kliče metodo dodaj. Poleg
# tega ima razred IskalnoDrevo še dve metodi in sicer:
# 
# * metodo pravilno, ki preveri, če je to drevo res pravilno iskalno
#   drevo, in
# * metodo drevo, ki vrne to drevo kot objekt razreda Drevo (navadno
#   dvojiško drevo).
# 
# Zgled:
# 
# >>> d = IskalnoDrevo([3, 9, 2, 4, 1, 8, 7, 6])
# >>> d.drevo()
# Drevo(3,
#       levo=Drevo(2,
#                  levo=Drevo(1)),
#       desno=Drevo(9,
#                   levo=Drevo(4,
#                              desno=Drevo(8,
#                                          levo=Drevo(7,
#                                                     levo=Drevo(6))))))
#######################################################################@@#

class Drevo:

    def __init__(self, *args, **kwargs):
        if args:
            self.prazno = False
            self.vsebina = args[0]
            self.levo = kwargs.get('levo', Drevo())
            self.desno = kwargs.get('desno', Drevo())
        else:
            self.prazno = True

    def __repr__(self, zamik=''):
        if self.prazno:
            return 'Drevo()'.format(zamik)
        else:
            ret = 'Drevo({0}'.format(self.vsebina) + \
                (',\n{0}      levo={1}'.format(
                    zamik,
                    self.levo.__repr__(zamik + '           ')
                ) if not self.levo.prazno else '') + \
                (',\n{0}      desno={1}'.format(
                    zamik,
                    self.desno.__repr__(zamik + '            ')
                ) if not self.desno.prazno else '') + \
                ')'    
            return ret


class IskalnoDrevo:

    def __init__(self, vsebina=[]):
        self.prazno = True
        for n in vsebina:
            self.dodaj(n)

    def drevo(self, zamik=''):
        if self.prazno:
          return Drevo()
        else:
          return Drevo(self.vsebina,
                       levo=self.levo.drevo(),
                       desno=self.desno.drevo())

    def pravilno(self, minimum=None, maksimum=None):
        if self.prazno:
            return True
        elif minimum and self.vsebina < minimum:
            return False
        elif maksimum and self.vsebina > maksimum:
            return False
        else:
            return (self.levo.pravilno(minimum, self.vsebina) and
                    self.desno.pravilno(self.vsebina, maksimum))

    def dodaj(self, podatek):
        if self.prazno:
            self.prazno = False
            self.vsebina = podatek
            self.levo = IskalnoDrevo()
            self.desno = IskalnoDrevo()
        elif self.vsebina > podatek:
            self.levo.dodaj(podatek)
        elif self.vsebina < podatek:
            self.desno.dodaj(podatek)

##################################################################@000515#
# 1) Razredu IskalnoDrevo dodajte metodo prestej_manjse(self, n), ki
# prešteje, koliko vozlišč v iskalnem drevesu ima vsebino manjšo od n.
# Zgled:
# 
# >>> d = IskalnoDrevo([3, 9, 2, 4, 1, 8, 7, 6])
# >>> d.prestej_manjse(5)
# 4
# 
# _Pozor:_ Ni nujno, da se n pojavi v drevesu!
##################################################################000515@#


##################################################################@000516#
# 2) Razredu IskalnoDrevo dodajte metodo vsota_interval(self, a, b), ki
# izračuna vsoto vseh elementov $x$ v drevesu self, za katere velja
# $a \leq x \leq b$. Zgled:
# 
# >>> d = IskalnoDrevo([3, 9, 2, 4, 1, 8, 7, 6])
# >>> d.vsota_interval(2, 6)
# 15
# 
# _Pozor:_ Ni nujno, da se $a$ in $b$ pojavita v drevesu.
##################################################################000516@#


#######################################################################@@#
