#######################################################################@@#
# Najdaljše strogo naraščajoče podzaporedje 
#
# Za dano zaporedje celih števil $a = [a_0, a_1, \ldots, a_{n-1}]$ želimo
# najti najdaljše strogo naraščajoče podzaporedje (v nadaljevanju NSNP),
# ne nujno strnjeno.
# 
# Npr. v zaporedju $[0, 8, 4, 12, 2, 10, 6, 14, 1]$ je eno od možnih takih
# NSNP $[0, 4, 10, 14]$. Naj $d(a, i)$ predstavlja dolžino NSNP, ki se
# _konča s členom_ $a_i$. Vemo naslednje:
# $$
# d(a, i) = 1 + \max\{ d(a, j) \mid j < i, a_j < a_i \},
# $$
# pri čemer je maksimum prazne množice enak 0.
#######################################################################@@#

def je_podzaporedje(s, l):
    '''
    Vrni True, če je s podzaporedje zaporedja l, in False sicer.
    '''
    i = 0
    for j in range(len(l)):
        if s[i] == l[j]:
            i += 1
        if i >= len(s):
            return True
    return False

def je_narascajoce(l):
    '''
    Vrni True, če je l strogo naraščajoče zaporedje števil, in False sicer.
    '''
    for i in range(len(l) - 1):
        if l[i] >= l[i + 1]:
            return False
    return True

##################################################################@000517#
# 1) Naivna rekurzivna implementacija funkcije $d(a, i)$ je zelo neučinkovita.
# Sestavite funkcijo dolzina(a), ki vrne tabelo vrednosti
# $[d(a, 0), d(a, 1), \ldots, d(a, n - 1)]$. Funkcija naj bo učinkovita
# tudi za večje tabele. Ocenite časovno zahtevnost svoje funkcije.
# Zgled:
# 
# >>> dolzina([0, 8, 4, 12, 2, 10, 6, 14, 1])
# [1, 2, 2, 3, 2, 3, 3, 4, 2]
##################################################################000517@#


##################################################################@000518#
# 2) Sestavite funkcijo nsnp(a), ki vrne enega od NSNP-jev za tabelo a.
# 
# Funkcija naj najprej izračuna tabeli
# $[d(a, 0), d(a, 1), \ldots, d(a, n-1)]$ in
# $j = [j_0, j_1, \ldots, j_{n-1}]$,
# pri čemer je $j_k$ tisti indeks, pri katerem je dosežen maksimum v
# definiciji $d(a, k)$. Poseben primer je $j_k = \texttt{None}$, če je
# maksimum v definiciji prazen. Zaporedje
# $$
# a[i], a[j[i]], a[j[j[i]]], a[j[j[j[i]]]], \ldots
# $$
# ki se ustavi, ko naletimo na $j[j[\cdots]] = \texttt{None}$, je najdaljše
# naraščajoče podzaporedje, ki se konča z $a[i]$, zapisano v _obratnem
# vrstnem redu_. Njegova dolžina je $d(a, i)$. S pomočjo tega lahko hitro
# poiščemo NSNP za tabelo $a$.
# 
# Zgled:
# 
# >>> nsnp([0, 8, 4, 12, 2, 10, 6, 14, 1])
# [0, 4, 10, 14]
##################################################################000518@#


#######################################################################@@#
