% Nastavi lastne vrednosti 3x3 simetricne matrike
% Zaradi ortogonalne podobnosti je dovolj gledati diagonalno matriko

lambda = [-2; 0; 100];

meje = sort(lambda);
N = 200000;
close all

% Generiramo nakljucne tocke na enotski sferi v RR^3
X = randn(3,N);
for i = 1:N
    X(:,i) = X(:,i)/norm(X(:,i));
end

barva = zeros(N,1);

warning off
for i=1:N
    z = X(:,i);
    rho = rqiter(lambda,z);
    if rho<(meje(1)+meje(2))/2
        barva(i) = 1;
    elseif rho<(meje(2)+meje(3))/2
        barva(i) = 2;
    else
        barva(i) = 3;
    end
end
warning on

ind1 = find(barva==1);
ind2 = find(barva==2);
ind3 = find(barva==3);
delez = [length(ind1) length(ind2) length(ind3)]/N

% plot(X(1,ind1),X(2,ind1),'r.');
% hold on
% plot(X(1,ind2),X(2,ind2),'b.');
% plot(X(1,ind3),X(2,ind3),'g.');
% title('Projekcija (1,2)')
% hold off
% 
% figure
% plot(X(2,ind1),X(3,ind1),'r.');
% hold on
% plot(X(2,ind2),X(3,ind2),'b.');
% plot(X(2,ind3),X(3,ind3),'g.');
% title('Projekcija (2,3)')
% hold off
% 
% figure
% plot(X(1,ind1),X(3,ind1),'r.');
% hold on
% plot(X(1,ind2),X(3,ind2),'b.');
% plot(X(1,ind3),X(3,ind3),'g.');
% title('Projekcija (1,3)')
% legend('show');
% hold off

figure
plot3(X(1,ind1),X(2,ind1),X(3,ind1),'r.', 'DisplayName', '\lambda_3');
hold on
plot3(X(1,ind2),X(2,ind2),X(3,ind2),'b.', 'DisplayName', '\lambda_2');
plot3(X(1,ind3),X(2,ind3),X(3,ind3),'g.', 'DisplayName', '\lambda_1');
title('Enotska sfera')
legend('show')
hold off
axis equal
    