% narisi(A, vrednost)
%
% Izrise obe kroznici, doloceni z enacbo vrednost = ro(A, x),
% kjer je ro Rayleighov kvocient  in je A simetricna 3x3 matrika
% ter x iz enotske sfere. Ce drugi argument ni podan, ga nastavimo na
% srednjo lastno vrednost.
function narisi(A, vrednost)

spekter = sort(eig(A));
l1 = spekter(3);
l2 = spekter(2);
l3 = spekter(1);

if nargin == 1
    vrednost = l2;
    kot = acos((2 * l2 - l3 - l1) / (l1 - l3));
    kot = min(pi, kot);
    kotSt = kot * 180 / pi;
    fprintf('Kot med kroznicama: %.2f radianov oz. %.2f stopinj\n', kot, kotSt);
end

if vrednost > l1 || vrednost < l3
    fprintf('Pogoj l3 <= vrednost <= l1 ni izpolnjen, ker ne velja\n');
    fprintf('%f <= %f <= %f\n', l3, vrednost, l1);
    vrednost = max(l3, vrednost);
    vrednost = min(l1, vrednost);
    fprintf('Nova vrednost: %f\n', vrednost);
end

y0 = (vrednost - l3) / (l2 - l3);
z0 = (l2 - vrednost) / (l2 - l3);

a2 = (l1 - l3) / (l2 - l3);
a3 = (l1 - l2) / (l2 - l3);

koren2 = @(y1) sqrt(y0 - a2 * y1.^2);
if vrednost == l2
    koren3 = @(y1) sqrt(a3) * y1;
else
    koren3 = @(y1) sqrt(z0 + a3 * y1.^2);
end

y2pos = @(y1) koren2(y1);
y3pos = @(y1) koren3(y1);

mejaY2 = sqrt(y0 / a2);  % |y1| <= mejaY2
mejaY3 = sqrt(max([0, -z0 / a3]));    % |y2| >= mejaY3
fprintf('%f <= |y1| <= %f\n', mejaY3, mejaY2)
% mejaY3 <= |x| <= mejaY2. Vedno velja: mejaY3 <= mejaY2
stTock = 25;
neg = linspace(-mejaY2, -mejaY3, stTock);
y1s = [neg; -fliplr(neg)]; % morda imamo y1 = 0 dvakrat, ni vazno
y2sPos = y2pos(y1s);
y3sPos = y3pos(y1s);
% Morda se pojavijo opozorila o imaginarnih komponentah,
% lahko preverimo, da so enake 0.
y2sPos = real(y2sPos);
y3sPos = real(y3sPos);

debelina = 2;
clf;
hold on;
plot3(y1s(1,:), y2sPos(1,:), y3sPos(1,:), 'r', 'LineWidth', debelina, 'DisplayName', 'y2+y3+');
plot3(y1s(1,:), y2sPos(1,:), -y3sPos(1,:), 'g', 'LineWidth', debelina,'DisplayName', 'y2+y3-');
plot3(y1s(1,:), -y2sPos(1,:), y3sPos(1,:), 'b', 'LineWidth', debelina,'DisplayName', 'y2-y3+');
plot3(y1s(1,:), -y2sPos(1,:), -y3sPos(1,:), 'k', 'LineWidth', debelina,'DisplayName', 'y2-y3-');
if vrednost == l2
    legend('show');
end
plot3(y1s(2,:), y2sPos(2,:), y3sPos(2,:), 'r', 'LineWidth', debelina);
plot3(y1s(2,:), y2sPos(2,:), -y3sPos(2,:), 'g', 'LineWidth', debelina);
plot3(y1s(2,:), -y2sPos(2,:), y3sPos(2,:), 'b', 'LineWidth', debelina);
plot3(y1s(2,:), -y2sPos(2,:), -y3sPos(2,:), 'k', 'LineWidth', debelina)
% krogla
n = 20;
tocke = zeros(3, n^2);
kam = 0;
for alfa = linspace(0, 2 * pi, n)
    for beta = linspace(0, 2 * pi, n);
        kam = kam + 1;
        tocke(1:3, kam) = [cos(beta) * cos(alfa);
                           cos(beta) * sin(alfa);
                           sin(beta)];
    end
end
plot3(tocke(1,:), tocke(2,:), tocke(3,:), 'ko');

axis equal
xlabel('x') % x-axis label
ylabel('y') % y-axis label
zlabel('z')
hold off;

end