function lambda = rayleighBrute(A, z0)

n = length(A);
toleranca = 10^-10;
razlika = 2 * toleranca;
z = z0 / norm(z0);
sigmaPotem = rayKvocient(A, z);
maxIter = 100;
k = 0;
while razlika > toleranca & k < maxIter
   sigmaZdaj = sigmaPotem;
   y = (A - sigmaZdaj * eye(n)) \ z;
   z = y / norm(y);
   sigmaPotem = rayKvocient(A, z);
   razlika = abs(sigmaPotem - sigmaZdaj);
   k = k + 1;
end

if razlika <= toleranca
    nizFormat = 'Konvergenca.\nKoraki: %d\nsig: %f\nabs(sig1 -sig2): %f\n'
    fprintf(nizFormat, k, sigmaPotem, razlika);
else
    fprintf('Metoda ni skonvergirala: razlika = %f', razlika);
end

end