from tkinter import *
from podatki import stevke_ucna_mno, opisi_ucna_mno
from random import random


class Stevka:
    """
    Preprost razred, s pomocjo katerega prikazemo sliko dane stevke.
    """
    def __init__(self, vred, piksli):
        """
        :param vred: stevka, ki jo piksli predstavlja
        :param piksli: opis slike
        :return:
        """
        self.vred = vred
        dolz = len(piksli)  # pretvorimo v matriko za lazje risanje
        dim = int(dolz ** 0.5)
        while dim ** 2 != dolz:
            dim += 1
        self.opis_slike = [piksli[i * dim: (i + 1) * dim] for i in range(dim)]

    def prikazi(self):
        def pretvori_sivino(k):
            assert 0 <= k <= 255
            return str(round(100 * k / 255))  # python hoce deleze v odstotkih
        n = len(self.opis_slike)
        height = 700
        width = height
        okno = Tk()
        platno = Canvas(okno, height=height, width=width, bg="black")
        platno.grid(row=0, column=0)
        dimEnota = int(height / n)
        odmik = 5
        for i in range(n):
            for j in range(n):
                x1, y1 = dimEnota * i + odmik, dimEnota * j + odmik
                x2, y2 = dimEnota * (i + 1) + odmik, dimEnota * (j + 1) + odmik
                barva = "grey" + pretvori_sivino(self.opis_slike[j][i])
                platno.create_rectangle(x1, y1, x2, y2, fill=barva)
        okno.title("Število {}".format(self.vred))
        okno.mainloop()


# narisimo nakljucnih 10 stevil: vsako se bo odprlo v svojem oknu
for i in range(10):
    ind = int(random() * len(stevke_ucna_mno))
    n = Stevka(stevke_ucna_mno[ind], opisi_ucna_mno[ind])
    n.prikazi()


