def nalozi(datoteka):
    """
    Preberemo ucno in testno mnotico
    :param datoteka: Pot do datoteke, katere struktura je taka:

    ucna;<stevilo primerov v ucni mnozic>
    <vrednost stevke>;<vrstica, ki opisuje stevko>
    ...
    testna;<stevilo primerov v testni mnozici>
    ...

    :return: stevke_ucna, opisi_ucna, stevke_testna, opisi_testna
    """
    with open(datoteka) as f:
        # ucna mnozica
        vrsta = f.readline().strip()
        ucnih_primerov = int(vrsta[vrsta.find(";") + 1:])
        stevke_ucna = [None] * ucnih_primerov
        opisi_ucna = [None] * ucnih_primerov
        for i in range(ucnih_primerov):
            stevka, opis = f.readline().strip().split(";")
            stevke_ucna[i] = int(stevka)
            opisi_ucna[i] = eval(opis)

        # testna mnozica
        vrsta = f.readline().strip()
        testnih_primerov = int(vrsta[vrsta.find(";") + 1:])
        stevke_testna = [None] * testnih_primerov
        opisi_testna = [None] * testnih_primerov
        for i in range(testnih_primerov):
            stevka, opis = f.readline().strip().split(";")
            stevke_testna[i] = int(stevka)
            opisi_testna[i] = eval(opis)
    return stevke_ucna, opisi_ucna, stevke_testna, opisi_testna


# Podatki so izsek tistih, ki jih lahko najdemo na http://yann.lecun.com/exdb/mnist/
stevke_ucna_mno, opisi_ucna_mno, stevke_testna_mno, opisi_testna_mno = nalozi("stevke800ucna200testna.txt")
print("Nalozil podatke")
