function [X, lamb] = kvadratna(A0, A1, A2, nacin)

if nacin == 0
    [X, lamb] = polyeig(A0, A1, A2);
else
    g0 = norm(A0, 2);
    g1 = norm(A1, 2);
    g2 = norm(A2, 2);

    g = g1 / sqrt(g0 * g2);

    a = 1 / sqrt(g2 / g0);
    b = 2 / (1 + g) / g0;

    AA0 = b * A0;
    AA1 = a * b * A1;
    AA2 = a^2 * b * A2;

    [X, mi] = polyeig(AA0, AA1, AA2);
    lamb = a * mi;
end

end