% vnesemo podatke in rešimo nalogo

% fiksne tocke: oglisca N-kotnika
N = 16;
oglisca = zeros(N, 2);
for i = 1:N
    fi = 2 * pi / N * i;
    oglisca(i, 1) = cos(fi);
    oglisca(i, 2) = sin(fi);
end

% notranje tocke definiramo kot zarotiran pravilni K-kotnik,
% ki ga potem malo zmotimo
rand ('state', 21);

K = 10;
notranje_tocke = zeros(K, 2);
r = 0.5;
stopnja_motenja = 0.5* r;
dfi = 2 * pi / K * rand();
for i = 1:K
    fi = dfi + 2 * pi / K * i;
    dx = stopnja_motenja * (2 * rand() - 1); % premaknemo za +-
    dy = stopnja_motenja * (2 * rand() - 1); % stopnja_motenja
    notranje_tocke(i, 1) = r * cos(fi) + dx;
    notranje_tocke(i, 2) = r * sin(fi) + dy;
end

vse_tocke = [oglisca; notranje_tocke];

% Polozaj tocke bo predolocen ze s stirimi razdaljami d(tocka, sosed).
sosedje = 15; % vsaj toliko razdalj poznamo za vsako notranjo tocko 
razdalje = zeros(K * sosedje, 3);
vrsta = 0;
for i = 1:K
    ind = N + i;
    kandidati = [1:(ind - 1), (ind + 1):(N + K)];
    kandidati = kandidati(randperm(length(kandidati)));
    kandidati = kandidati(1:sosedje);
    for sos = kandidati
        levi = min(ind, sos);
        desni = max(ind, sos);
        % preverimo, ali ze imamo ta par
        nimam = true;
        for j = 1:(vrsta -1)
            if razdalje(j, 1) == levi && razdalje(j, 2) == desni
                nimam = false;
                break;
            end
        end
        if nimam
            vrsta = vrsta + 1;
            d = razdalja(vse_tocke(levi,:), vse_tocke(desni,:));
            razdalje(vrsta, :) = [levi, desni, d];
        end
    end
end

razdalje = razdalje(1:vrsta,:);
opis = 'Karakteristike omrezja:\n- fiksne tocke: %d\n- premicne tocke: %d\n- povezave: %d\n';
fprintf(opis, N, K, vrsta);

priblizek = reshape(notranje_tocke', 2 * K, 1) + 0.1 * rand(2 * K, 1);
tocna_mesta = 3;
t = 10^tocna_mesta;
pokvarjeneR = [razdalje(:,1:2), round(razdalje(:,3) * t) ./ t];

% Resimo 4 primere:
% 1) s tocnimi razdaljami in slabim zacetnim priblizkom,
% 2) s tocnimi razdaljami in dobrim zac. prib,
% 3) z malo pokvarjenenimi razdaljami in slab zac. priblizkom,
% 4) z malo pokvarjenimi razdaljami in dobrim zac. priblizkom.

primer = 4;

if primer == 1
    [koordinate, napaka] = razporejanjeTock(oglisca, razdalje);
elseif primer == 2
    [koordinate, napaka] = razporejanjeTock(oglisca, razdalje, priblizek);
elseif primer == 3
    [koordinate, napaka] = razporejanjeTock(oglisca, pokvarjeneR);  
elseif primer == 4
    [koordinate, napaka] = razporejanjeTock(oglisca, pokvarjeneR, priblizek);
end

fprintf('Napaka v primeru %d: %f\n', primer, napaka);
prikaziStanje(oglisca, koordinate, notranje_tocke, razdalje)

