% Izrisemo zacetne podatke ter odkrito resitev. Argumenti so naslednji:
% - fiksne: [x1 y1; x2 y2; ...] - matrika s koordinatami fiksnih tock
% - trenuti_pribl: [x(N + 1); y(N + 1); x(N + 2); y(N + 2); ...] - vektor
%                  priblizkov za premicne tocke
% - resitev: sestavljena kot matrika fiksne, vsebuje koordinate zacetnih tock,
%            iz katerih smo izracunali vrednosti d(Ti, Tj)
% - razdalje: matrika vrstic dolzine 3 oblike [i j d(Ti, Tj)], kjer sta i in j
%             indeksa tock, d(Ti, Tj) pa razdalja med njima
function prikaziStanje(fiksne, trenuti_pribl, resitev, razdalje)

clf
hold on
% tocke
n = length(trenuti_pribl);
plot(fiksne(:,1), fiksne(:,2), 'ro')
plot(trenuti_pribl(1:2:n), trenuti_pribl(2:2:n), 'bo')
plot(resitev(:,1), resitev(:,2), 'mx')

premicne = [trenuti_pribl(1:2:n), trenuti_pribl(2:2:n)];
vse_tocke = [fiksne; premicne];

% povezave
for i = 1:size(razdalje, 1)
    par = vse_tocke(razdalje(i, 1:2),:);
    plot(par(:,1)', par(:,2)', 'k-');
end

axis([-2 2 -2 2])
axis equal
hold off

end