package si.lj.uni.fmf.pro2.lectures.extra;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import si.lj.uni.fmf.pro2.lectures.networks.Graph;

public class IMDb {
	
	public static void main(String[] args) {
		Graph graph = null;
		try {
			graph = Graph.read(new File("nets", "IMDb.net"));
		} catch (IOException e) {
			e.printStackTrace();
			return;
		}
		
		for (String title: args) {
			int teleport = -1;
			for (int node: graph.getNodes())
				if (graph.getLabel(node).split(" - ")[0].equals(title)) {
					teleport = node;
					break;
				}
			
			Map<Integer, Double> simranks = simranks(graph, teleport);
			
			List<Integer> nodes = new ArrayList<Integer>();
			for (int node: graph.getNodes())
				if (node != teleport && !graph.getLabel(node).startsWith("m-"))
					nodes.add(node);
			
			Collections.sort(nodes, new Comparator<Integer>() {
				@Override
				public int compare(Integer first, Integer second) {
					return -simranks.get(first).compareTo(simranks.get(second));
				}
			});
			
			System.out.format("%16s | '%s'\n", "Teleport", graph.getLabel(teleport).split(" - ")[0]);
			for (int i = 0; i < nodes.size(); i++)
				if (i < 25)
					System.out.format("%16f | '%s'\n", simranks.get(nodes.get(i)), graph.getLabel(nodes.get(i)).split(" - ")[0]);
				else
					break;
			
			System.out.println();
		}
	}
	
	public static Map<Integer, Double> simranks(Graph graph, int teleport) {
		return simranks(graph, teleport, 0.85, 10e-12);
	}
	
	public static Map<Integer, Double> simranks(Graph graph, int teleport, double damping, double epsilon) {
		Map<Integer, Double> simranks = new HashMap<Integer, Double>();
		
		for (int node: graph.getNodes())
			simranks.put(node, 1.0 / graph.getN());
		
		double difference, unleaked;
		do {
			difference = 0.0; unleaked = 0.0;
			
			Map<Integer, Double> updated = new HashMap<Integer, Double>();
			
			for (int node: graph.getNodes()) {
				double simrank = 0.0;
				for (int neighbor: graph.getNeighbors(node))
					simrank += damping * simranks.get(neighbor) / graph.getDegree(neighbor);

				unleaked += simrank;
				
				updated.put(node, simrank);
			}	
			
			updated.put(teleport, updated.get(teleport) + 1.0 - unleaked);
			
			for (int node: graph.getNodes())
				difference += Math.abs(updated.get(node) - simranks.get(node));
			
			simranks = updated;
		} while (difference >= epsilon);
		
		return simranks;
	}

}
