package si.lj.uni.fmf.pro2.lectures.networks;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Console extends JPanel {
	
	private static final long serialVersionUID = 1L;
	
	protected static final int CONSOLE_SIZE = 64;
	
	protected static final int CONTROL_SIZE = 48;
	
	private JComboBox<Layout> combo;
	
	private JCheckBox[] checks;
	
	public Console(GUI GUI) {
		super();
		
		setFocusable(false);
		setPreferredSize(new Dimension(getWidth(), CONSOLE_SIZE));
		
		combo = new JComboBox<Layout>(new Layout[] { Layout.SPRING, Layout.CIRCULAR, Layout.RANDOM });
		combo.setToolTipText("Select network layout");
		combo.setSelectedItem(GUI.getSettings().getLayout());
		combo.setPreferredSize(new Dimension((int)Math.round(2.25 * CONTROL_SIZE), CONTROL_SIZE));
		combo.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				GUI.getSettings().setLayout((Layout)combo.getSelectedItem());
				
				Enumeration<AbstractButton> items = GUI.getCombo().getElements();
				while (items.hasMoreElements()) {
					AbstractButton item = items.nextElement();
					if (item.getText().equals(GUI.getSettings().getLayout().toString())) {
						item.setSelected(true);
						break;
					}
				}
				
				if (GUI.getSettings().getLayout().equals(Layout.RANDOM))
					GUI.setLayouting(new Layouting(GUI.getGraph()));
				else if (GUI.getSettings().getLayout().equals(Layout.CIRCULAR))
					GUI.setLayouting(Layouting.circular(GUI.getGraph()));
				else
					GUI.setLayouting(Layouting.spring(GUI.getGraph()));
				
				GUI.repaint();
			}
		});
		add(combo);
		
		JButton button = new JButton(new ImageIcon(Networks.ICONS_FOLDER + "/layout.png"));
		button.setToolTipText("Compute network layout");
		button.setPreferredSize(new Dimension(CONTROL_SIZE, CONTROL_SIZE));
		button.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				if (GUI.getSettings().getLayout().equals(Layout.RANDOM))
					GUI.setLayouting(new Layouting(GUI.getGraph()));
				else if (GUI.getSettings().getLayout().equals(Layout.CIRCULAR))
					GUI.setLayouting(Layouting.circular(GUI.getGraph()));
				else
					GUI.setLayouting(Layouting.spring(GUI.getGraph()));
				
				GUI.repaint();
			}
		});
		add(button);
		
		button = new JButton(new ImageIcon(Networks.ICONS_FOLDER + "/clusters.png"));
		button.setToolTipText("Compute node clustering");
		button.setPreferredSize(new Dimension(CONTROL_SIZE, CONTROL_SIZE));
		button.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				GUI.getGraph().clustering();
				
				GUI.repaint();
			}
		});
		add(button);
		
		add(new JLabel("    "));
		
		checks = new JCheckBox[3];
		
		checks[0] = new JCheckBox("Labels");
		checks[0].setToolTipText("Show node labels");
		checks[0].setSelected(GUI.getSettings().isLabels());
		checks[0].addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				GUI.getSettings().setLabels(((JCheckBox)e.getSource()).isSelected());
				GUI.getChecks()[0].setSelected(GUI.getSettings().isLabels());
				
				GUI.repaint();
			}
		});
		add(checks[0]);
		
		JSlider slider = new JSlider(1, 32, GUI.getSettings().getTexts());
		slider.setToolTipText("Set label size");
		slider.setPreferredSize(new Dimension((int)Math.round(2.5 * CONTROL_SIZE), CONTROL_SIZE));
		slider.addChangeListener(new ChangeListener() {
			@Override
			public void stateChanged(ChangeEvent e) {
				GUI.getSettings().setTexts(((JSlider)e.getSource()).getValue());
				
				GUI.repaint();
			}
		});
		add(slider);
		
		checks[1] = new JCheckBox("Centrality");
		checks[1].setToolTipText("Show node centrality");
		checks[1].setSelected(GUI.getSettings().isCentrality());
		checks[1].addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				GUI.getSettings().setCentrality(((JCheckBox)e.getSource()).isSelected());
				GUI.getChecks()[1].setSelected(GUI.getSettings().isCentrality());
				
				GUI.repaint();
			}
		});
		add(checks[1]);
		
		slider = new JSlider(8, 32, GUI.getSettings().getSizes());
		slider.setToolTipText("Set node size");
		slider.setPreferredSize(new Dimension((int)Math.round(2.5 * CONTROL_SIZE), CONTROL_SIZE));
		slider.addChangeListener(new ChangeListener() {
			@Override
			public void stateChanged(ChangeEvent e) {
				GUI.getSettings().setSizes(((JSlider)e.getSource()).getValue());
				
				GUI.repaint();
			}
		});
		add(slider);
		
		checks[2] = new JCheckBox("Clusters");
		checks[2].setToolTipText("Show node clusters");
		checks[2].setSelected(GUI.getSettings().isClusters());
		checks[2].addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				GUI.getSettings().setClusters(((JCheckBox)e.getSource()).isSelected());
				GUI.getChecks()[2].setSelected(GUI.getSettings().isClusters());
				
				GUI.repaint();
			}
		});
		add(checks[2]);
	}
	
	public JComboBox<Layout> getCombo() {
		return combo;
	}

	public JCheckBox[] getChecks() {
		return checks;
	}

}