package si.lj.uni.fmf.pro2.lectures.networks;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

import de.erichseifert.vectorgraphics2d.PDFGraphics2D;

public class GUI extends JFrame {
	
	private static final long serialVersionUID = 1L;
	
	private File file;
	
	private Graph graph;
	
	private Layouting layouting;
	
	private Settings settings;
	
	private JCheckBoxMenuItem[] checks;
	
	private ButtonGroup combo;
	
	private Console console;
	
	private Panel panel;
	
	public GUI(String file) throws IOException {
		this(file, Graph.read(file));
	}
	
	public GUI(String file, Graph graph) {
		super();
		
		this.graph = graph;
		this.file = new File(file);
		this.settings = new Settings();
		
		switch (settings.getLayout()) {
		case SPRING: default:
			this.layouting = Layouting.spring(graph);
			break;
		case CIRCULAR:
			this.layouting = Layouting.circular(graph);
			break;
		case RANDOM:
			this.layouting = new Layouting(graph);
			break;
		}
		
		final GUI GUI = this;
		
		setTitle(graph.getName());
		getRootPane().putClientProperty("apple.awt.brushMetalLook", true);
		setPreferredSize(new Dimension(1024, 824));
		setMinimumSize(new Dimension(800, 600));
		setLayout(new BorderLayout());
		
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		
		add(console = new Console(this), BorderLayout.NORTH);
		add(panel = new Panel(this), BorderLayout.CENTER);
		add(new Summary(this), BorderLayout.SOUTH);
		
		JMenuBar bar = new JMenuBar();
		setJMenuBar(bar);
		
		JMenu menu = new JMenu("File");
	    bar.add(menu);
	    
	    JMenuItem item = new JMenuItem("New");
	    item.setAccelerator(KeyStroke.getKeyStroke('N', Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
	    item.setIcon(UIManager.getIcon("FileView.fileIcon"));
	    item.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				Graph graph = Graph.random(256, 8.0);
				
				GUI GUI = new GUI(Networks.NETWORKS_FOLDER + "/" + graph.getName() + ".net", graph);
				Networks.GUIs.add(GUI);
				
				GUI.setVisible(true);
			}
		});
	    menu.add(item);
	    
	    item = new JMenuItem("Open...");
	    item.setAccelerator(KeyStroke.getKeyStroke('O', Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
	    item.setIcon(UIManager.getIcon("Tree.openIcon"));
	    item.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				FileDialog dialog = new FileDialog(GUI, null, FileDialog.LOAD);
				dialog.setLocationRelativeTo(GUI);
				
				dialog.setDirectory(Networks.NETWORKS_FOLDER);
			    dialog.setFilenameFilter(new FilenameFilter() {
					@Override
					public boolean accept(File directory, String name) {
						return name.endsWith(".net");
					}
				});
			    if (GUI.getFile() != null)
			    	dialog.setFile(GUI.getFile().getName());
			    
			    dialog.setVisible(true);
			    
			    String file = dialog.getFile();
			    String folder = dialog.getDirectory();
			    if (folder != null && file != null)
			    	try {
			    		GUI GUI = new GUI(folder + file);
			    		Networks.GUIs.add(GUI);
			    		
						GUI.setVisible(true);
					} catch (IOException ex) {
					
					}
			}
		});
	    menu.add(item);
	    
	    menu.addSeparator();
	    
	    item = new JMenuItem("Close");
	    item.setAccelerator(KeyStroke.getKeyStroke('W', Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
	    item.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				dispose();
			}
		});
	    menu.add(item);
	    
	    item = new JMenuItem("Close All");
	    item.setAccelerator(KeyStroke.getKeyStroke('W', ActionEvent.SHIFT_MASK + Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
	    item.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				for (GUI GUI: Networks.GUIs)
					GUI.dispose();
			}
		});
	    menu.add(item);
	    
	    menu.addSeparator();
	    
	    item = new JMenuItem("Save");
	    item.setAccelerator(KeyStroke.getKeyStroke('S', Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
	    item.addActionListener(new ActionListener() {
	    	@Override
	    	public void actionPerformed(ActionEvent e) {
	    		if (GUI.getGraph() != null && GUI.getFile() != null)
	    			try {
	    				Graph.write(GUI.getGraph(), GUI.getFile());
	    			} catch (IOException ex) {
	    				ex.printStackTrace();
	    			}
	    	}
		});
	    menu.add(item);
	    
	    item = new JMenuItem("Save As...");
	    item.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				if (GUI.getGraph() != null && GUI.getFile() != null) {
					FileDialog dialog = new FileDialog(GUI, null, FileDialog.SAVE);
					dialog.setLocationRelativeTo(GUI);
					
					dialog.setDirectory(Networks.NETWORKS_FOLDER);
					dialog.setFilenameFilter(new FilenameFilter() {
						@Override
						public boolean accept(File directory, String name) {
							return name.endsWith(".net");
						}
					});
					dialog.setFile(GUI.getGraph().getName() + ".txt");
					
					dialog.setVisible(true);

					String file = dialog.getFile();
					String folder = dialog.getDirectory();
					if (folder != null && file != null)
						try {
							Graph.write(GUI.getGraph(), folder + file);
						} catch (IOException ex) {
							ex.printStackTrace();
						}
				}
			}
		});
	    menu.add(item);
	    
	    item = new JMenuItem("Save All");
	    item.setAccelerator(KeyStroke.getKeyStroke('S', ActionEvent.SHIFT_MASK + Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
	    item.addActionListener(new ActionListener() {
	    	@Override
	    	public void actionPerformed(ActionEvent e) {
	    		for (GUI GUI: Networks.GUIs)
	    			if (GUI.getGraph() != null && GUI.getFile() != null)
	    				try {
	    					Graph.write(GUI.getGraph(), GUI.getFile());
	    				} catch (IOException ex) {
	    					ex.printStackTrace();
	    				}
	    	}
		});
	    menu.add(item);
	    
	    menu.addSeparator();
	    
	    item = new JMenuItem("Export...");
	    item.setIcon(new JFileChooser().getIcon(new File(Networks.ICONS_FOLDER + "/blank.pdf")));
	    item.addActionListener(new ActionListener() {
	    	@Override
	    	public void actionPerformed(ActionEvent e) {
	    		if (GUI.getGraph() != null && GUI.getFile() != null) {
	    			FileDialog dialog = new FileDialog(GUI, null, FileDialog.SAVE);
	    			dialog.setLocationRelativeTo(GUI);
	    			
	    			dialog.setDirectory(Networks.NETWORKS_FOLDER);
	    			dialog.setFilenameFilter(new FilenameFilter() {
	    				@Override
	    				public boolean accept(File directory, String name) {
	    					return name.endsWith(".pdf");
	    				}
	    			});
	    			dialog.setFile(GUI.getFile().getName().replace(".net", ".pdf"));
	    			
	    			dialog.setVisible(true);

	    			String file = dialog.getFile();
	    			String folder = dialog.getDirectory();
	    			if (folder != null && file != null) {
	    				PDFGraphics2D graphics = new PDFGraphics2D(0, 0, panel.getWidth(), panel.getHeight());
	    				panel.paint(graphics);

	    				try {
	    					FileOutputStream stream = new FileOutputStream(new File(folder + file));

	    					stream.write(graphics.getBytes());

	    					stream.flush(); 
	    					stream.close(); 
	    				} catch (IOException ex) {
	    					ex.printStackTrace();
	    				}
	    			}
	    		}
	    	}
		});
	    menu.add(item);
	    
		menu = new JMenu("Graph");
	    bar.add(menu);
	    
	    item = new JMenuItem("Relayout");
	    item.setAccelerator(KeyStroke.getKeyStroke('L', Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
	    item.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				switch (settings.getLayout()) {
				case SPRING: default:
					layouting = Layouting.spring(graph);
					break;
				case CIRCULAR:
					layouting = Layouting.circular(graph);
					break;
				case RANDOM:
					layouting = new Layouting(graph);
					break;
				}
				
				GUI.repaint();
			}
		});
	    menu.add(item);

	    item = new JMenuItem("Clustering");
	    item.setAccelerator(KeyStroke.getKeyStroke('C', Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
	    item.addActionListener(new ActionListener() {
	    	@Override
	    	public void actionPerformed(ActionEvent e) {
	    		getGraph().clustering();
	    		
	    		GUI.repaint();
	    	}
		});
	    menu.add(item);
	    
	    menu = new JMenu("View");
	    bar.add(menu);
	    
	    JMenu submenu = new JMenu("Layout");
		menu.add(submenu);

		combo = new ButtonGroup();
		for (Layout layouts: Layout.values()) { 
			JRadioButtonMenuItem radio = new JRadioButtonMenuItem(layouts.toString(), layouts.equals(GUI.getSettings().getLayout()));
			radio.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent e) {
					settings.setLayout(Layout.valueOf(radio.getText().toUpperCase()));
					console.getCombo().setSelectedItem(settings.getLayout());

					switch (settings.getLayout()) {
					case SPRING: default:
						layouting = Layouting.spring(graph);
						break;
					case CIRCULAR:
						layouting = Layouting.circular(graph);
						break;
					case RANDOM:
						layouting = new Layouting(graph);
						break;
					}
					
					GUI.repaint();
				}
			});
			submenu.add(radio);
			combo.add(radio);
		}
		
		menu.addSeparator();
		
		checks = new JCheckBoxMenuItem[3];
		
		checks[0] = new JCheckBoxMenuItem("Labels", settings.isLabels());
		checks[0].addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				settings.setLabels(checks[0].isSelected());
				console.getChecks()[0].setSelected(settings.isLabels());
				
				GUI.repaint();
			}
		});
		menu.add(checks[0]);
		
		checks[1] = new JCheckBoxMenuItem("Centrality", settings.isCentrality());
		checks[1].addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				settings.setCentrality(checks[1].isSelected());
				console.getChecks()[1].setSelected(settings.isCentrality());
				
				GUI.repaint();
			}
		});
		menu.add(checks[1]);
		
		checks[2] = new JCheckBoxMenuItem("Clusters", settings.isClusters());
		checks[2].addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				settings.setClusters(checks[2].isSelected());
				console.getChecks()[2].setSelected(settings.isClusters());
				
				GUI.repaint();
			}
		});
		menu.add(checks[2]);
		
	    bar.add(new JMenu("Help"));
		
		pack(); 
	}
	
	public File getFile() {
		return file;
	}
	
	public Graph getGraph() {
		return graph;
	}

	public Layouting getLayouting() {
		return layouting;
	}

	public void setLayouting(Layouting layouting) {
		this.layouting = layouting;
	}

	public Settings getSettings() {
		return settings;
	}

	public JCheckBoxMenuItem[] getChecks() {
		return checks;
	}

	public ButtonGroup getCombo() {
		return combo;
	}
	
}