package si.lj.uni.fmf.pro2.lectures.networks;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import javax.swing.JPanel;

public class Panel extends JPanel {
	
	private static final long serialVersionUID = 1L;
	
	protected static final Color[] NODE_COLORS = new Color[] { 
			new Color(211, 211, 211), new Color(76, 187, 23), new Color(93, 33, 120), new Color(76, 128, 155), new Color(128, 128, 128) };

	protected static final Color EDGE_COLOR = new Color(96, 96, 96);

	protected static final Color LABEL_COLOR = Color.BLACK;
	
	protected static final int BORDER_SIZE = 48;
	
	private GUI GUI;
	
	private int selected;
	
	public Panel(GUI GUI) {
		super();
		
		this.GUI = GUI;
		
		selected = -1;
		
		setBackground(Color.WHITE);
		
		addMouseListener(new MouseListener() { 
			
			@Override
			public void mousePressed(MouseEvent e) {
				for (int node: GUI.getGraph().getNodes()) {
					int size = GUI.getSettings().getSizes();
					if (GUI.getSettings().isCentrality())
						size = (int)Math.round(4 + 0.25 * size * Math.pow(Math.min(GUI.getGraph().getDegree(node), 12), 0.75));
					
					if (Math.sqrt(Math.pow(BORDER_SIZE + GUI.getLayouting().getX(node) * (getWidth() - 2 * BORDER_SIZE) - e.getX(), 2.0) + Math.pow(BORDER_SIZE + GUI.getLayouting().getY(node) * (getHeight() - 2 * BORDER_SIZE) - e.getY(), 2.0)) <= size / 2)
						selected = node;
				}
			}
			
			@Override
			public void mouseReleased(MouseEvent e) {
				selected = -1;
			}
			
			@Override
			public void mouseClicked(MouseEvent e) {
				
			}
			
			@Override
			public void mouseEntered(MouseEvent e) {
				
			}
			
			@Override
			public void mouseExited(MouseEvent e) {
				
			}
			
		});
		
		addMouseMotionListener(new MouseMotionListener() {
			
			@Override
			public void mouseMoved(MouseEvent e) {
				
			}
			
			@Override
			public void mouseDragged(MouseEvent e) {
				if (selected != -1)
					GUI.getLayouting().setPoint(selected, new Point(Math.min(1.0, Math.max(0.0, 1.0 * (e.getX() - BORDER_SIZE) / (getWidth() - 2 * BORDER_SIZE))), Math.min(1.0, Math.max(0.0, 1.0 * (e.getY() - BORDER_SIZE) / (getHeight() - 2 * BORDER_SIZE)))));
				
				GUI.repaint();
			}
			
		});
	}

	@Override
	public void paint(Graphics g) {
		super.paint(g);
		
		int width = getWidth() - 2 * BORDER_SIZE;
		int height = getHeight() - 2 * BORDER_SIZE;
		
		Graphics2D graphics = (Graphics2D)g;
		
		graphics.setColor(EDGE_COLOR);
		graphics.setStroke(new BasicStroke(2.0f));
		
		for (Edge edge: GUI.getGraph().getEdges())
			if (GUI.getLayouting().getX(edge.getFirst()) >= 0.0 && GUI.getLayouting().getY(edge.getFirst()) >= 0.0 && GUI.getLayouting().getX(edge.getSecond()) >= 0.0 && GUI.getLayouting().getY(edge.getSecond()) >= 0.0)
				graphics.drawLine((int)Math.round(BORDER_SIZE + GUI.getLayouting().getX(edge.getFirst()) * width), (int)Math.round(BORDER_SIZE + GUI.getLayouting().getY(edge.getFirst()) * height), (int)Math.round(BORDER_SIZE + GUI.getLayouting().getX(edge.getSecond()) * width), (int)Math.round(BORDER_SIZE + GUI.getLayouting().getY(edge.getSecond()) * height));

		for (int node: GUI.getGraph().getNodes()) 
			if (GUI.getLayouting().getX(node) >= 0.0 && GUI.getLayouting().getY(node) >= 0.0) {
				int size = GUI.getSettings().getSizes();
				if (GUI.getSettings().isCentrality())
					size = (int)Math.round(4 + 0.25 * size * Math.pow(Math.min(GUI.getGraph().getDegree(node), 12), 0.75));

				graphics.setColor(NODE_COLORS[GUI.getSettings().isClusters()? GUI.getGraph().getCluster(node) % NODE_COLORS.length: 0]);
				graphics.setStroke(new BasicStroke(1.0f));

				graphics.fillOval((int)Math.round(BORDER_SIZE + GUI.getLayouting().getX(node) * width - size / 2), (int)Math.round(BORDER_SIZE + GUI.getLayouting().getY(node) * height - size / 2), size, size);

				graphics.setColor(EDGE_COLOR);
				graphics.setStroke(new BasicStroke(2.0f));

				graphics.drawOval((int)Math.round(BORDER_SIZE + GUI.getLayouting().getX(node) * width - size / 2), (int)Math.round(BORDER_SIZE + GUI.getLayouting().getY(node) * height - size / 2), size, size);
			}
		
		if (GUI.getSettings().isLabels()) {
			graphics.setColor(LABEL_COLOR);
			graphics.setStroke(new BasicStroke(1.0f));
			graphics.setFont(new Font(Font.DIALOG, Font.BOLD, GUI.getSettings().getTexts()));
			FontMetrics metrics = graphics.getFontMetrics(); 
			
			for (int node: GUI.getGraph().getNodes()) 
				if (GUI.getLayouting().getX(node) >= 0.0 && GUI.getLayouting().getY(node) >= 0.0)
					graphics.drawString(GUI.getGraph().getLabel(node), (int)Math.round(BORDER_SIZE + GUI.getLayouting().getX(node) * width - metrics.stringWidth(GUI.getGraph().getLabel(node)) / 2), (int)Math.round(BORDER_SIZE + GUI.getLayouting().getY(node) * height + metrics.getAscent() / 2));
		}
	}
	
}