package si.lj.uni.fmf.pro2.lectures.networks;

public class Point {
	
	protected double x;
	
	protected double y;
	
	public Point() {
		this(Math.random(), Math.random());
	}

	public Point(double x, double y) {
		super();
		
		this.x = x;
		this.y = y;
	}

	public double getX() {
		return x;
	}

	public void setX(double x) {
		this.x = x;
	}

	public double getY() {
		return y;
	}

	public void setY(double y) {
		this.y = y;
	}

	public double norm() {
		return Math.sqrt(x * x + y * y);
	}

	public void offset(double x, double y) {
		this.x += x;
		this.y += y;
	}
	
	public Point delta(Point point) {
		return new Point(x - point.getX(), y - point.getY());
	}
	
}