package si.lj.uni.fmf.pro2.lectures.networks;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JPanel;

public class Summary extends JPanel {
	
	private static final long serialVersionUID = 1L;
	
	protected static final int SUMMARY_HEIGHT = 100;
	
	protected static final int SUMMARY_WIDTH = 312;
	
	protected static final int BORDER_SIZE = 16;
	
	private GUI GUI;

	public Summary(GUI GUI) {
		super();
		
		this.GUI = GUI;
		
		setFocusable(false);
		setPreferredSize(new Dimension(getWidth(), SUMMARY_HEIGHT));
	}

	@Override
	public void paint(Graphics g) {
		super.paint(g);
		
		Graphics2D graphics = (Graphics2D)g;

		RoundRectangle2D rectangle = new RoundRectangle2D.Float(getWidth() / 2 - SUMMARY_WIDTH / 2, BORDER_SIZE, SUMMARY_WIDTH, getHeight() - 2 * BORDER_SIZE, 10, 10);
		
		graphics.setColor(new Color(246, 246, 246));
		graphics.setStroke(new BasicStroke(1.0f));
		
        graphics.fill(rectangle);
		
        graphics.setColor(Color.BLACK);
        
        graphics.draw(rectangle);
        
		graphics.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 13));
		FontMetrics metrics = graphics.getFontMetrics();
		
		int y = (getHeight() - 3 * metrics.getHeight()) / 2 + 3 * metrics.getHeight() / 4;
		
		graphics.drawString("Nodes: ", getWidth() / 2 - SUMMARY_WIDTH / 4 - metrics.stringWidth("Nodes: "), y);
		graphics.drawString("Edges: ", getWidth() / 2 - SUMMARY_WIDTH / 4 - metrics.stringWidth("Edges: "), y + metrics.getHeight());
		graphics.drawString("Degree: ", getWidth() / 2 - SUMMARY_WIDTH / 4 - metrics.stringWidth("Degree: "), y + 2 * metrics.getHeight());
		
		graphics.setFont(new Font(Font.SANS_SERIF, Font.PLAIN, 13));
		metrics = graphics.getFontMetrics();
		
		graphics.drawString(String.format("%,d (%,d)", GUI.getGraph().getN(), GUI.getGraph().getI()), getWidth() / 2 - SUMMARY_WIDTH / 4, y);
		graphics.drawString(String.format("%,d (%,d)", GUI.getGraph().getM(), GUI.getGraph().getL()), getWidth() / 2 - SUMMARY_WIDTH / 4, y + metrics.getHeight());
		graphics.drawString(String.format("%.2f (%,d)", GUI.getGraph().getK(), GUI.getGraph().getD()), getWidth() / 2 - SUMMARY_WIDTH / 4, y + 2 * metrics.getHeight());
		
		graphics.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 13));
		metrics = graphics.getFontMetrics();
		
		graphics.drawString("Clusters: ", getWidth() / 2 + SUMMARY_WIDTH / 4 - metrics.stringWidth("Clusters: "), y + 0.5f * metrics.getHeight());
		graphics.drawString("Compons: ", getWidth() / 2 + SUMMARY_WIDTH / 4 - metrics.stringWidth("Compons: "), y + 1.5f * metrics.getHeight());

		graphics.setFont(new Font(Font.SANS_SERIF, Font.PLAIN, 13));
		metrics = graphics.getFontMetrics();
		
		Map<Integer, Integer> clusters = new HashMap<Integer, Integer>();
		for (int node: GUI.getGraph().getNodes()) {
			if (!clusters.containsKey(GUI.getGraph().getCluster(node)))
				clusters.put(GUI.getGraph().getCluster(node), 0);
			clusters.put(GUI.getGraph().getCluster(node), clusters.get(GUI.getGraph().getCluster(node)) + 1);
		}
		
		int LCC = 0;
		for (int size: clusters.values())
			if (size > LCC)
				LCC = size;
		
		graphics.drawString(String.format("%,d (%.0f%%)", clusters.size(), 100.0 * LCC / GUI.getGraph().getN()), getWidth() / 2 + SUMMARY_WIDTH / 4, y + 0.5f * metrics.getHeight());
		
		List<Integer> components = Graph.components(GUI.getGraph());
		
		LCC = 0;
		for (int size: components)
			if (size > LCC)
				LCC = size;
		
		graphics.drawString(String.format("%,d (%.0f%%)", components.size(), 100.0 * LCC / GUI.getGraph().getN()), getWidth() / 2 + SUMMARY_WIDTH / 4, y + 1.5f * metrics.getHeight());
	}

}