package si.lj.uni.fmf.pro2.lectures.pacmans;

/**
 * Class representing a big {@link Coin} on a {@link Board} represented by the Cartesian coordinate plane.
 * 
 * The big {@link Coin} is represented by its {@link Position} in the plane which is occupiable, while its intrinsic value equals {@link Pacmans#BIG_COIN_VALUE} and its label equals {@code 'O'}.
 * 
 * @author Lovro Šubelj
 */
public class BigCoin extends Coin {

	/**
	 * Constructs a big {@link Coin} on a {@link Board} represented by the Cartesian coordinate plane.
	 * 
	 * The big {@link Coin} is specified by its {@link Position} in the plane which is occupiable, while its intrinsic value equals {@link Pacmans#BIG_COIN_VALUE} and its label equals {@code 'O'}.
	 * 
	 * @param position {@link Position} of the {@link Coin} on a {@link Board}
	 */
	public BigCoin(Position position) {
		super(position, Pacmans.BIG_COIN_VALUE, 'O');
	}
	
}