package si.lj.uni.fmf.pro2.lectures.pacmans;

/**
 * Class representing a coin {@link Cell} on a {@link Board} represented by the Cartesian coordinate plane.
 * 
 * The coin {@link Cell} is represented by its {@link Position} in the plane which is occupiable, its intrinsic value and a predefined label.
 * 
 * @author Lovro Šubelj
 */
public abstract class Coin extends Cell {

	/**
	 * Constructs a coin {@link Cell} on a {@link Board} represented by the Cartesian coordinate plane.
	 * 
	 * The coin {@link Cell} is specified by its {@link Position} in the plane which is occupiable, its intrinsic value and a predefined label.
	 * 
	 * @param position {@link Position} of the {@link Cell} on a {@link Board}
	 * @param value intrinsic non-negative value of the {@link Cell}
	 * @param label predefined label or character of the {@link Cell}
	 */
	public Coin(Position position, int value, char label) {
		super(position, value, label, true);
	}
	
	/**
	 * Returns randomly selected coin {@link Cell} at the specified {@link Position} on a {@link Board}.
	 * 
	 * The function returns either {@link BigCoin}, {@link SmallCoin} or {@link TinyCoin} with equal probability.
	 * 
	 * @param position {@link Position} of the coin {@link Cell} on a {@link Board}
	 * 
	 * @return random coin {@link Cell} at the specified {@link Position} on a {@link Board} 
	 */
	public static Coin random(Position position) {
		double random = Math.random();
		if (random < 0.3333)
			return new BigCoin(position);
		else if (random < 0.6667)
			return new SmallCoin(position);
		else
			return new TinyCoin(position);
	}
	
}