package si.lj.uni.fmf.pro2.lectures.pacmans;

/**
 * Class representing an empty {@link Cell} on a {@link Board} represented by the Cartesian coordinate plane.
 * 
 * The {@link Cell} is represented by its {@link Position} in the plane which is occupiable, while its intrinsic value equals {@code 0} and its label equals {@code ' '}.
 * 
 * @author Lovro Šubelj
 */
public class Empty extends Cell {

	/**
	 * Constructs an empty {@link Cell} on a {@link Board} represented by the Cartesian coordinate plane.
	 * 
	 * The {@link Cell} is specified by its {@link Position} in the plane which is occupiable, while its intrinsic value equals {@code 0} and its label equals {@code ' '}.
	 * 
	 * @param position {@link Position} of the {@link Cell} on a {@link Board}
	 */
	public Empty(Position position) {
		super(position, 0, ' ', true);
	}
	
}