package si.lj.uni.fmf.pro2.lectures.pacmans;

/**
 * Class representing a PAC-MAN {@link Cell} on a {@link Board} represented by the Cartesian coordinate plane.
 * 
 * The PAC-MAN {@link Cell} is represented by its {@link Position} in the plane which is non-occupiable and a predefined label, while its intrinsic value equals {@code 0}.
 * 
 * @author Lovro Šubelj
 */
public class Pacman extends Cell {
	
	/**
	 * Boolean representing whether the PAC-MAN {@link Cell} is prime (i.e. smart).
	 */
	private boolean prime;

	/**
	 * Constructs a non-prime PAC-MAN {@link Cell} on a {@link Board} represented by the Cartesian coordinate plane.
	 * 
	 * The PAC-MAN {@link Cell} is specified by its {@link Position} in the plane which is non-occupiable and a predefined label, while its intrinsic value equals {@code 0}.
	 * 
	 * @param position {@link Position} of the {@link Cell} on a {@link Board}
	 * @param label predefined label or character of the {@link Cell}
	 */
	public Pacman(Position position, char label) {
		this(position, label, false);
	}
	
	/**
	 * Constructs a PAC-MAN {@link Cell} on a {@link Board} represented by the Cartesian coordinate plane.
	 * 
	 * The PAC-MAN {@link Cell} is specified by its {@link Position} in the plane which is non-occupiable and a predefined label, while its intrinsic value equals {@code 0}.
	 * 
	 * @param position {@link Position} of the {@link Cell} on a {@link Board}
	 * @param label predefined label or character of the {@link Cell}
	 * @param prime whether the {@link Cell} is prime (i.e. smart)
	 */
	public Pacman(Position position, char label, boolean prime) {
		super(position, 0, label, false);
		
		this.prime = prime;
	}

	/**
	 * Returns whether the PAC-MAN {@link Cell} on a {@link Board} is prime.
	 * 
	 * @return whether the PAC-MAN {@link Cell} on a {@link Board} is prime
	 */
	public boolean isPrime() {
		return prime;
	}

	/**
	 * Sets whether the PAC-MAN {@link Cell} on a {@link Board} is prime.
	 * 
	 * @param prime whether the PAC-MAN {@link Cell} on a {@link Board} is prime
	 */
	public void setPrime(boolean prime) {
		this.prime = prime;
	}

}